/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast.string.parameterrefiners;

import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.lookup.JMethodLookupException;
import com.android.jack.reflection.MemberFinder;
import com.android.jack.reflection.MultipleMethodsFoundException;
import com.android.jack.shrob.obfuscation.OriginalNames;
import com.android.jack.transformations.ast.string.parameterrefiners.GetMethodParameterRefiner;
import com.android.sched.schedulable.Access;
import com.android.sched.schedulable.Constraint;
import java.util.ArrayList;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Constraint(need={OriginalNames.class})
@Access(value=JSession.class)
public class GetDeclaredMethodParameterRefiner
extends GetMethodParameterRefiner {
    @Nonnull
    private static final String GETDECLAREDMETHOD_METHOD_NAME = "getDeclaredMethod";
    @Nonnull
    private final JMethodIdWide getDeclaredMethodMethodId;

    public GetDeclaredMethodParameterRefiner() {
        ArrayList<JType> parameterList = new ArrayList<JType>(2);
        parameterList.add(this.javaLangString);
        parameterList.add(this.javaLangClassArray);
        this.getDeclaredMethodMethodId = this.javaLangClass.getMethodIdWide(GETDECLAREDMETHOD_METHOD_NAME, parameterList, MethodKind.INSTANCE_VIRTUAL);
    }

    @Override
    public boolean isApplicable(@Nonnull JMethodCall call) throws JMethodLookupException {
        if (call.getReceiverType().isSameType(this.javaLangClass) && call.getMethodId().equals(this.getDeclaredMethodMethodId)) {
            assert (formatter.getName(call.getType()).equals("Ljava/lang/reflect/Method;"));
            return true;
        }
        return false;
    }

    @Override
    @CheckForNull
    protected JMethod lookupMethod(@Nonnull JDefinedClassOrInterface type, @Nonnull String methodSignature) {
        JMethod foundMethod = null;
        try {
            foundMethod = MemberFinder.getDirectMethod(type, methodSignature);
        }
        catch (MultipleMethodsFoundException multipleMethodsFoundException) {
            // empty catch block
        }
        return foundMethod;
    }
}

