/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast.inner;

import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JMethod;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

@ValidOn(value={JDefinedClassOrInterface.class})
@Description(value="This marker indicates that a field or method inside the classis accessed from an inner class.")
public class ReferencedFromInnerClassMarker
implements Marker {
    @Nonnull
    private final HashSet<JField> fields = new HashSet();
    @Nonnull
    private final HashSet<JMethod> methods = new HashSet();

    @Nonnull
    Set<JMethod> getMethods() {
        return this.methods;
    }

    @Nonnull
    Set<JField> getFields() {
        return this.fields;
    }

    synchronized void addField(@Nonnull JField field) {
        this.fields.add(field);
    }

    synchronized void addMethod(@Nonnull JMethod method) {
        this.methods.add(method);
    }

    @Override
    @Nonnull
    public Marker cloneIfNeeded() {
        throw new AssertionError((Object)"Not yet supported");
    }
}

