/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast.inner;

import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JFieldRef;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JParameterRef;
import com.android.jack.ir.ast.JReturnStatement;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.transformations.ast.inner.InnerAccessorGenerator;
import com.android.jack.transformations.request.AppendMethodParam;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.util.NamingTools;
import com.android.sched.item.AbstractComponent;
import com.android.sched.item.ComposedOf;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import java.util.Collection;
import java.util.HashMap;
import javax.annotation.Nonnull;

@ValidOn(value={JDefinedClass.class})
@Description(value="This marker indicates that a field has an associated getter.")
public class GetterMarker
implements Marker {
    @Nonnull
    private static final String GETTER_PREFIX = NamingTools.getNonSourceConflictingName("get");
    @Nonnull
    private final HashMap<JField, JMethod> getters = new HashMap();

    @Nonnull
    Collection<JMethod> getAllGetters() {
        return this.getters.values();
    }

    @Override
    @Nonnull
    public Marker cloneIfNeeded() {
        throw new AssertionError((Object)"Not yet supported");
    }

    @Nonnull
    JMethod getOrCreateGetter(@Nonnull JField field, @Nonnull JDefinedClass accessorClass, @Nonnull TransformationRequest tr) {
        JMethod getter = this.getters.get(field);
        if (getter == null) {
            SourceInfo sourceInfo = SourceInfo.UNKNOWN;
            String getterName = GETTER_PREFIX;
            getterName = getterName + field.getName();
            JMethodId id = new JMethodId(new JMethodIdWide(getterName, MethodKind.STATIC), field.getType());
            getter = new JMethod(sourceInfo, id, accessorClass, 4104);
            JParameterRef instance = null;
            if (!field.isStatic()) {
                JParameter thisParam = new JParameter(sourceInfo, InnerAccessorGenerator.THIS_PARAM_NAME, accessorClass, 4096, getter);
                tr.append(new AppendMethodParam(getter, thisParam));
                instance = thisParam.makeRef(sourceInfo);
            }
            JFieldRef returnedRef = new JFieldRef(sourceInfo, instance, field.getId(), accessorClass);
            JReturnStatement returnSt = new JReturnStatement(sourceInfo, returnedRef);
            JBlock bodyBlock = new JBlock(sourceInfo);
            JMethodBody body = new JMethodBody(sourceInfo, bodyBlock);
            bodyBlock.addStmt(returnSt);
            getter.setBody(body);
            assert (!this.getters.containsKey(field));
            this.getters.put(field, getter);
        }
        return getter;
    }

    @Name(value="InnerAccessorGetter")
    @Description(value="All JNodes created for a getter allowing to access an inner field.")
    @ComposedOf(value={JMethod.class, JMethodCall.class, JParameter.class, JParameterRef.class, JFieldRef.class, JReturnStatement.class, JMethodBody.class, JBlock.class})
    static class InnerAccessorGetter
    implements AbstractComponent {
        InnerAccessorGetter() {
        }
    }
}

