/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.assertion;

import com.android.jack.Options;
import com.android.jack.ir.ast.JAssertStatement;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.assertion.DisabledAssertionFeature;
import com.android.jack.transformations.request.Remove;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnull;

@Description(value="Remove assert statements")
@Name(value="AssertionRemover")
@Constraint(need={JAssertStatement.class})
@Transform(remove={JAssertStatement.class})
@Support(value={DisabledAssertionFeature.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class AssertionRemover
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public synchronized void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        TransformationRequest tr = new TransformationRequest(method);
        Visitor visitor = new Visitor(tr);
        visitor.accept(method);
        tr.commit();
    }

    private static class Visitor
    extends JVisitor {
        @Nonnull
        private final TransformationRequest tr;

        public Visitor(@Nonnull TransformationRequest tr) {
            this.tr = tr;
        }

        @Override
        public void endVisit(@Nonnull JAssertStatement assertSt) {
            this.tr.append(new Remove(assertSt));
        }
    }
}

