/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JDefinedInterface;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JSession;
import com.android.jack.library.TypeInInputLibraryLocation;
import com.android.jack.lookup.JLookup;
import com.android.jack.transformations.request.Remove;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.sched.item.Synchronized;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.util.location.Location;
import com.android.sched.util.log.LoggerFactory;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Synchronized
public abstract class TypeRemover
implements RunnableSchedulable<JDefinedClassOrInterface> {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private final JLookup lookup = Jack.getSession().getLookup();
    @Nonnull
    private final JSession session = Jack.getSession();

    protected boolean isTypeFromClasspath(@Nonnull JDefinedClassOrInterface type) {
        Location location = type.getLocation();
        return location instanceof TypeInInputLibraryLocation && this.session.getLibraryOnClasspath().contains(((TypeInInputLibraryLocation)location).getInputLibrary());
    }

    private void updateSuperTypeList(@Nonnull JDefinedClassOrInterface type) {
        if (type instanceof JDefinedClass) {
            JClass superClass = type.getSuperClass();
            while (this.mustBeRemovedInternal(superClass)) {
                assert (superClass != null);
                for (JInterface i : ((JDefinedClass)superClass).getImplements()) {
                    this.addImplements(type, i);
                }
                superClass = ((JDefinedClass)superClass).getSuperClass();
            }
            ((JDefinedClass)type).setSuperClass(superClass);
        }
        ArrayList<JInterface> implementsCopy = new ArrayList<JInterface>(type.getImplements());
        for (JInterface i : implementsCopy) {
            if (!this.mustBeRemovedInternal(i)) continue;
            JDefinedInterface jDefinedInterface = (JDefinedInterface)i;
            type.remove(jDefinedInterface);
            for (JInterface subInterface : jDefinedInterface.getImplements()) {
                this.addImplements(type, subInterface);
            }
        }
    }

    private boolean mustBeRemovedInternal(@CheckForNull JClassOrInterface type) {
        if (type instanceof JDefinedClassOrInterface) {
            return this.mustBeRemoved((JDefinedClassOrInterface)type);
        }
        return false;
    }

    protected abstract boolean mustBeRemoved(@Nonnull JDefinedClassOrInterface var1);

    protected abstract boolean isPlannedForRemoval(@Nonnull JMethod var1);

    private void addImplements(@Nonnull JDefinedClassOrInterface type, @Nonnull JInterface i) {
        if (!type.getImplements().contains(i)) {
            if (!this.mustBeRemovedInternal(i)) {
                type.addImplements(i);
            } else {
                for (JInterface subInterface : ((JDefinedInterface)i).getImplements()) {
                    this.addImplements(type, subInterface);
                }
            }
        }
    }

    @Override
    public synchronized void run(@Nonnull JDefinedClassOrInterface type) {
        boolean toRemove = this.mustBeRemoved(type);
        if (toRemove) {
            TransformationRequest request = new TransformationRequest(type);
            request.append(new Remove(type));
            logger.log(Level.INFO, "Removed type {0}", Jack.getUserFriendlyFormatter().getName(type));
            JClassOrInterface enclosing = type.getEnclosingType();
            if (enclosing instanceof JDefinedClassOrInterface) {
                JDefinedClassOrInterface enclosingType = (JDefinedClassOrInterface)enclosing;
                enclosingType.removeMemberType(type);
            }
            Jack.getSession().removeTypeToEmit(type);
            request.commit();
        } else {
            this.updateSuperTypeList(type);
            this.updateEnclosingType(type);
            if (type instanceof JDefinedClass) {
                this.updateEnclosingMethod((JDefinedClass)type);
            }
        }
        this.lookup.removeType(type);
    }

    private void updateEnclosingType(@Nonnull JDefinedClassOrInterface type) {
        JClassOrInterface enclosingType = type.getEnclosingType();
        while (enclosingType instanceof JDefinedClassOrInterface && this.mustBeRemovedInternal(enclosingType) && !this.isTypeFromClasspath(type)) {
            enclosingType = ((JDefinedClassOrInterface)enclosingType).getEnclosingType();
        }
        type.setEnclosingType(enclosingType);
    }

    private void updateEnclosingMethod(@Nonnull JDefinedClass type) {
        JMethod enclosingMethod = type.getEnclosingMethod();
        if (enclosingMethod != null && this.isPlannedForRemoval(enclosingMethod)) {
            assert (enclosingMethod.getEnclosingType().isToEmit());
            type.setEnclosingMethod(null);
        }
    }
}

