/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.tools.merger;

import com.android.jack.dx.dex.file.ClassDefItem;
import com.android.jack.dx.dex.file.DexFile;
import com.android.jack.dx.dex.file.EncodedField;
import com.android.jack.dx.dex.file.EncodedMethod;
import com.android.jack.dx.dex.file.ImportedCodeItem;
import com.android.jack.dx.dex.file.ImportedDebugInfoItem;
import com.android.jack.dx.io.ClassData;
import com.android.jack.dx.io.ClassDef;
import com.android.jack.dx.io.Code;
import com.android.jack.dx.io.DexBuffer;
import com.android.jack.dx.rop.code.AccessFlags;
import com.android.jack.dx.rop.cst.CstIndexMap;
import com.android.jack.dx.rop.cst.CstMethodRef;
import com.android.jack.dx.rop.cst.CstString;
import com.android.jack.dx.rop.cst.CstType;
import com.android.jack.dx.rop.type.StdTypeList;
import com.android.jack.dx.rop.type.TypeList;
import com.android.jack.tools.merger.AnnotationMerger;
import com.android.jack.tools.merger.ConstantManager;
import com.android.jack.tools.merger.MergerTools;
import com.android.jack.tools.merger.MergingOverflowException;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;

public class JackMerger
extends MergerTools {
    @Nonnull
    private final ConstantManager cstManager = new ConstantManager();
    @Nonnull
    private final AnnotationMerger am = new AnnotationMerger();
    @Nonnull
    private final DexFile dexResult;
    private boolean finished = false;

    public JackMerger(@Nonnull DexFile dexResult) {
        this.dexResult = dexResult;
        dexResult.getDexOptions().forceJumbo = true;
    }

    public void addDexFile(@Nonnull DexBuffer dexToMerge) throws MergingOverflowException {
        if (this.finished) {
            throw new AssertionError((Object)"Merge already finished");
        }
        CstIndexMap cstIndexMap = this.cstManager.addDexFile(dexToMerge);
        for (ClassDef classDefToMerge : dexToMerge.classDefs()) {
            CstType superType = null;
            int supertypeIndex = classDefToMerge.getSupertypeIndex();
            if (supertypeIndex != -1) {
                superType = cstIndexMap.getCstType(supertypeIndex);
            }
            CstString sourceFilename = null;
            int sourceFileIndex = classDefToMerge.getSourceFileIndex();
            if (sourceFileIndex != -1) {
                sourceFilename = cstIndexMap.getCstString(sourceFileIndex);
            }
            ClassDefItem newClassDef = new ClassDefItem(cstIndexMap.getCstType(classDefToMerge.getTypeIndex()), classDefToMerge.getAccessFlags(), superType, this.getInterfacesList(classDefToMerge, cstIndexMap), sourceFilename);
            this.dexResult.add(newClassDef);
            this.mergeAnnotations(dexToMerge, classDefToMerge, newClassDef, cstIndexMap);
            if (classDefToMerge.getClassDataOffset() == 0) continue;
            ClassData classDataToMerge = dexToMerge.readClassData(classDefToMerge);
            for (ClassData.Field fieldToMerge : classDataToMerge.getInstanceFields()) {
                newClassDef.addInstanceField(new EncodedField(cstIndexMap.getCstFieldRef(fieldToMerge.getFieldIndex()), fieldToMerge.getAccessFlags()));
            }
            MergerTools.ConstantValueArrayBuilder cvab = null;
            int staticValuesOffset = classDefToMerge.getStaticValuesOffset();
            if (staticValuesOffset != 0) {
                cvab = new MergerTools.ConstantValueArrayBuilder(dexToMerge, dexToMerge.open(staticValuesOffset));
                cvab.readArray();
            }
            int cstIdx = 0;
            for (ClassData.Field fieldToMerge : classDataToMerge.getStaticFields()) {
                EncodedField encodedField = new EncodedField(cstIndexMap.getCstFieldRef(fieldToMerge.getFieldIndex()), fieldToMerge.getAccessFlags());
                newClassDef.addStaticField(encodedField, cvab != null && cstIdx < cvab.getCstSize() ? cvab.getCstValueAtIdx(cstIdx++) : null);
            }
            for (ClassData.Method method : classDataToMerge.allMethods()) {
                EncodedMethod encodeMethod;
                CstMethodRef cstMethodRef = cstIndexMap.getCstMethodRef(method.getMethodIndex());
                ImportedCodeItem importCode = null;
                if (method.getCodeOffset() != 0) {
                    Code code = dexToMerge.readCode(method);
                    ImportedDebugInfoItem idii = code.getDebugInfoOffset() != 0 ? new ImportedDebugInfoItem(dexToMerge, code.getDebugInfoOffset(), cstIndexMap) : null;
                    importCode = new ImportedCodeItem(cstMethodRef, code, idii, cstIndexMap);
                }
                if (AccessFlags.isPrivate((encodeMethod = new EncodedMethod(cstMethodRef, method.getAccessFlags(), importCode)).getAccessFlags()) || AccessFlags.isStatic(encodeMethod.getAccessFlags()) || AccessFlags.isConstructor(encodeMethod.getAccessFlags())) {
                    newClassDef.addDirectMethod(encodeMethod);
                    continue;
                }
                newClassDef.addVirtualMethod(encodeMethod);
            }
        }
    }

    public void finish(@Nonnull OutputStream out) throws IOException {
        this.dexResult.prepare(this.cstManager.getCstStrings(), this.cstManager.getCstFieldRefs(), this.cstManager.getCstMethodRefs(), this.cstManager.getCstTypes(), this.cstManager.getCstPrototypeRefs());
        if (!this.cstManager.validate(this.dexResult)) {
            throw new AssertionError();
        }
        this.dexResult.writeTo(out, null, false);
        this.finished = true;
    }

    private void mergeAnnotations(@Nonnull DexBuffer dexToMerge, @Nonnull ClassDef classDefToMerge, @Nonnull ClassDefItem newClassDef, @Nonnull CstIndexMap cstIndexMap) {
        if (classDefToMerge.getAnnotationsOffset() != 0) {
            this.am.mergeAnnotationDirectory(dexToMerge, classDefToMerge.getAnnotationsOffset(), newClassDef, cstIndexMap);
        }
    }

    @Nonnull
    private TypeList getInterfacesList(@Nonnull ClassDef classDefToMerge, @Nonnull CstIndexMap cstIndexMap) {
        int interfaceCount = classDefToMerge.getInterfaces().length;
        if (interfaceCount == 0) {
            return StdTypeList.EMPTY;
        }
        StdTypeList interfaceList = new StdTypeList(interfaceCount);
        int idx = 0;
        for (short interfaceIdx : classDefToMerge.getInterfaces()) {
            interfaceList.set(idx++, cstIndexMap.getCstType(interfaceIdx).getClassType());
        }
        return interfaceList;
    }
}

