/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.tools.merger;

import com.android.jack.Jack;
import com.android.jack.dx.dex.file.DexFile;
import com.android.jack.dx.io.DexBuffer;
import com.android.jack.dx.io.FieldId;
import com.android.jack.dx.io.MethodId;
import com.android.jack.dx.io.ProtoId;
import com.android.jack.dx.rop.cst.CstFieldRef;
import com.android.jack.dx.rop.cst.CstIndexMap;
import com.android.jack.dx.rop.cst.CstMethodRef;
import com.android.jack.dx.rop.cst.CstNat;
import com.android.jack.dx.rop.cst.CstPrototypeRef;
import com.android.jack.dx.rop.cst.CstString;
import com.android.jack.dx.rop.cst.CstType;
import com.android.jack.dx.rop.type.Prototype;
import com.android.jack.dx.rop.type.Type;
import com.android.jack.tools.merger.FieldIdOverflowException;
import com.android.jack.tools.merger.MergerTools;
import com.android.jack.tools.merger.MergingOverflowException;
import com.android.jack.tools.merger.MethodIdOverflowException;
import com.android.jack.tools.merger.PrototypedOverflowException;
import com.android.jack.tools.merger.TypeIdOverflowException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class ConstantManager
extends MergerTools {
    @Nonnull
    private final Map<String, CstString> string2CstStrings = new HashMap<String, CstString>();
    @Nonnull
    private final HashSet<CstPrototypeRef> cstPrototypeRefs = new HashSet();
    @Nonnull
    private final HashSet<CstFieldRef> cstFieldRefs = new HashSet();
    @Nonnull
    private final HashSet<CstMethodRef> cstMethodRefs = new HashSet();
    @Nonnull
    private final HashSet<CstType> cstTypes = new HashSet();
    @Nonnull
    private final Map<String, CstString> protoStr2CstString = new HashMap<String, CstString>();

    @Nonnull
    public Collection<CstString> getCstStrings() {
        return Jack.getUnmodifiableCollections().getUnmodifiableCollection(this.string2CstStrings.values());
    }

    @Nonnull
    public Collection<CstFieldRef> getCstFieldRefs() {
        return Jack.getUnmodifiableCollections().getUnmodifiableCollection(this.cstFieldRefs);
    }

    @Nonnull
    public Collection<CstMethodRef> getCstMethodRefs() {
        return Jack.getUnmodifiableCollections().getUnmodifiableCollection(this.cstMethodRefs);
    }

    @Nonnull
    public Collection<CstType> getCstTypes() {
        return Jack.getUnmodifiableCollections().getUnmodifiableCollection(this.cstTypes);
    }

    @Nonnull
    public Collection<CstPrototypeRef> getCstPrototypeRefs() {
        return Jack.getUnmodifiableCollections().getUnmodifiableCollection(this.cstPrototypeRefs);
    }

    @Nonnull
    public CstIndexMap addDexFile(@Nonnull DexBuffer dexBuffer) throws MergingOverflowException {
        CstIndexMap cstIndexMap = new CstIndexMap(dexBuffer);
        ArrayList<String> cstStringsNewlyAdded = new ArrayList<String>();
        ArrayList<CstPrototypeRef> cstPrototypeRefsNewlyAdded = new ArrayList<CstPrototypeRef>();
        ArrayList<CstFieldRef> cstFieldRefsNewlyAdded = new ArrayList<CstFieldRef>();
        ArrayList<CstMethodRef> cstMethodRefsNewlyAdded = new ArrayList<CstMethodRef>();
        ArrayList<CstType> cstTypesNewlyAdded = new ArrayList<CstType>();
        int idx = 0;
        for (String string : dexBuffer.strings()) {
            CstString cstString = this.string2CstStrings.get(string);
            if (cstString == null) {
                cstString = new CstString(string);
                this.string2CstStrings.put(string, cstString);
                cstStringsNewlyAdded.add(string);
            }
            cstIndexMap.addStringMapping(idx++, cstString);
        }
        idx = 0;
        List<String> typeNames = dexBuffer.typeNames();
        for (String typeNameDesc : typeNames) {
            CstType cstType = null;
            cstType = typeNameDesc.equals(Type.VOID.getDescriptor()) ? CstType.intern(Type.VOID) : CstType.intern(Type.intern(typeNameDesc));
            if (this.cstTypes.add(cstType)) {
                cstTypesNewlyAdded.add(cstType);
            }
            cstIndexMap.addTypeMapping(idx++, cstType);
        }
        idx = 0;
        for (FieldId fieldId : dexBuffer.fieldIds()) {
            CstNat fieldNat = new CstNat(cstIndexMap.getCstString(fieldId.getNameIndex()), cstIndexMap.getCstType(fieldId.getTypeIndex()).getDescriptor());
            CstFieldRef cstFieldRef = new CstFieldRef(cstIndexMap.getCstType(fieldId.getDeclaringClassIndex()), fieldNat);
            if (this.cstFieldRefs.add(cstFieldRef)) {
                cstFieldRefsNewlyAdded.add(cstFieldRef);
            }
            cstIndexMap.addFieldMapping(idx++, cstFieldRef);
        }
        idx = 0;
        List<ProtoId> list = dexBuffer.protoIds();
        String[] protoIdx2String = new String[list.size()];
        for (ProtoId protoId : list) {
            String protoStr = dexBuffer.readTypeList(protoId.getParametersOffset()).toString();
            protoIdx2String[idx] = protoStr = protoStr + typeNames.get(protoId.getReturnTypeIndex());
            Prototype prototype = Prototype.intern(protoStr);
            CstPrototypeRef cstProtoRef = new CstPrototypeRef(prototype);
            if (this.cstPrototypeRefs.add(cstProtoRef)) {
                cstPrototypeRefsNewlyAdded.add(cstProtoRef);
            }
            cstIndexMap.addPrototypeMapping(idx++, cstProtoRef);
        }
        idx = 0;
        for (MethodId methodId : dexBuffer.methodIds()) {
            int protoIdx = methodId.getProtoIndex();
            String protoStr = protoIdx2String[protoIdx];
            assert (protoStr != null);
            CstString protoCstString = this.protoStr2CstString.get(protoStr);
            if (protoCstString == null) {
                protoCstString = new CstString(protoStr);
                this.protoStr2CstString.put(protoStr, protoCstString);
            }
            CstNat methNat = new CstNat(cstIndexMap.getCstString(methodId.getNameIndex()), protoCstString);
            CstMethodRef cstMethodRef = new CstMethodRef(cstIndexMap.getCstType(methodId.getDeclaringClassIndex()), methNat);
            if (this.cstMethodRefs.add(cstMethodRef)) {
                cstMethodRefsNewlyAdded.add(cstMethodRef);
            }
            cstIndexMap.addMethodMapping(idx++, cstMethodRef);
        }
        if (this.cstFieldRefs.size() > 65536) {
            this.removeItems(cstStringsNewlyAdded, cstFieldRefsNewlyAdded, cstMethodRefsNewlyAdded, cstTypesNewlyAdded, cstPrototypeRefsNewlyAdded);
            throw new FieldIdOverflowException();
        }
        if (this.cstMethodRefs.size() > 65536) {
            this.removeItems(cstStringsNewlyAdded, cstFieldRefsNewlyAdded, cstMethodRefsNewlyAdded, cstTypesNewlyAdded, cstPrototypeRefsNewlyAdded);
            throw new MethodIdOverflowException();
        }
        if (this.cstTypes.size() > 65536) {
            this.removeItems(cstStringsNewlyAdded, cstFieldRefsNewlyAdded, cstMethodRefsNewlyAdded, cstTypesNewlyAdded, cstPrototypeRefsNewlyAdded);
            throw new TypeIdOverflowException();
        }
        if (this.cstPrototypeRefs.size() > 65536) {
            this.removeItems(cstStringsNewlyAdded, cstFieldRefsNewlyAdded, cstMethodRefsNewlyAdded, cstTypesNewlyAdded, cstPrototypeRefsNewlyAdded);
            throw new PrototypedOverflowException();
        }
        return cstIndexMap;
    }

    private void removeItems(@Nonnull List<String> cstStringsToRemove, @Nonnull List<CstFieldRef> cstFieldRefsToRemove, @Nonnull List<CstMethodRef> cstMethodRefsToRemove, @Nonnull List<CstType> cstTypesToRemove, @Nonnull List<CstPrototypeRef> cstPrototypeRefsToRemove) {
        this.string2CstStrings.keySet().removeAll(cstStringsToRemove);
        this.cstFieldRefs.removeAll(cstFieldRefsToRemove);
        this.cstMethodRefs.removeAll(cstMethodRefsToRemove);
        this.cstTypes.removeAll(cstTypesToRemove);
        this.cstPrototypeRefs.removeAll(cstPrototypeRefsToRemove);
    }

    public boolean validate(@Nonnull DexFile dexFile) {
        return dexFile.getStringIds().items().size() == this.string2CstStrings.size() && dexFile.getFieldIds().items().size() == this.cstFieldRefs.size() && dexFile.getMethodIds().items().size() == this.cstMethodRefs.size() && dexFile.getTypeIds().items().size() == this.cstTypes.size();
    }
}

