/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.tonicsystems.jarjar;

import com.android.jack.tonicsystems.jarjar.PatternElement;
import com.android.jack.tonicsystems.jarjar.Rule;
import com.android.sched.util.file.ReaderFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RulesFileParser {
    private RulesFileParser() {
    }

    public static List<PatternElement> parse(ReaderFile file) throws IOException {
        return RulesFileParser.parse(file.getBufferedReader());
    }

    public static List<PatternElement> parse(String value) throws IOException {
        return RulesFileParser.parse(new StringReader(value));
    }

    private static String stripComment(String in) {
        int p = in.indexOf("#");
        return p < 0 ? in : in.substring(0, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PatternElement> parse(Reader r) throws IOException {
        try {
            String line;
            ArrayList<PatternElement> patterns = new ArrayList<PatternElement>();
            BufferedReader br = new BufferedReader(r);
            int c = 1;
            while ((line = br.readLine()) != null) {
                if ((line = RulesFileParser.stripComment(line)).isEmpty()) continue;
                String[] parts = line.split("\\s+");
                if (parts.length < 2) {
                    RulesFileParser.error(c, parts);
                }
                String type = parts[0];
                Rule element = null;
                if (type.equals("rule")) {
                    if (parts.length < 3) {
                        RulesFileParser.error(c, parts);
                    }
                    Rule rule = new Rule();
                    rule.setResult(parts[2]);
                    element = rule;
                } else {
                    if (type.equals("zap") || type.equals("keep")) continue;
                    RulesFileParser.error(c, parts);
                }
                assert (element != null);
                element.setPattern(parts[1]);
                patterns.add(element);
                ++c;
            }
            ArrayList<PatternElement> arrayList = patterns;
            return arrayList;
        }
        finally {
            r.close();
        }
    }

    private static void error(int line, String[] parts) {
        throw new IllegalArgumentException("Error on line " + line + ": " + Arrays.asList(parts));
    }
}

