/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.spec;

import com.android.jack.shrob.spec.ClassSpecification;
import com.android.jack.shrob.spec.FilterSpecification;
import com.android.jack.shrob.spec.NameSpecification;
import com.android.jack.shrob.spec.Specification;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class Flags {
    private boolean shrink = true;
    private boolean optimize = true;
    private boolean preverify = true;
    private boolean obfuscate = true;
    private boolean keepParameterNames = false;
    private boolean useMixedCaseClassName = true;
    @CheckForNull
    private File obfuscationMapping = null;
    private boolean printMapping = false;
    private boolean useUniqueClassMemberNames = false;
    @CheckForNull
    private String packageForRenamedClasses = null;
    @CheckForNull
    private String packageForFlatHierarchy = null;
    @CheckForNull
    private String libraryJars = null;
    @Nonnull
    private final List<File> inJars = new ArrayList<File>(1);
    @Nonnull
    private final List<File> outJars = new ArrayList<File>(1);
    @CheckForNull
    private File outputMapping;
    @CheckForNull
    private File obfuscationDictionary;
    @CheckForNull
    private File classObfuscationDictionary;
    @CheckForNull
    private File packageObfuscationDictionary;
    @Nonnull
    private final List<FilterSpecification> keepAttributes = new ArrayList<FilterSpecification>();
    @CheckForNull
    private String renameSourceFileAttribute;
    @Nonnull
    private final List<FilterSpecification> keepPackageNames = new ArrayList<FilterSpecification>();
    @Nonnull
    private final List<FilterSpecification> adaptClassStrings = new ArrayList<FilterSpecification>();
    @Nonnull
    private final List<ClassSpecification> keepClassSpecs = new ArrayList<ClassSpecification>();
    @Nonnull
    private final List<ClassSpecification> keepClassesWithMembersSpecs = new ArrayList<ClassSpecification>();
    @Nonnull
    private final List<ClassSpecification> keepClassMembersSpecs = new ArrayList<ClassSpecification>();
    private boolean printSeeds = false;
    @CheckForNull
    private File seedsFile;
    @Nonnull
    private final List<FilterSpecification> adaptResourceFileNames = new ArrayList<FilterSpecification>();
    @Nonnull
    private final List<FilterSpecification> adaptResourceFileContents = new ArrayList<FilterSpecification>();

    public void setShrink(boolean shrink) {
        this.shrink = shrink;
    }

    public void setOptimize(boolean optimize) {
        this.optimize = optimize;
    }

    public void setPreverify(boolean preverify) {
        this.preverify = preverify;
    }

    public void setPrintMapping(boolean printMapping) {
        this.printMapping = printMapping;
    }

    public boolean printMapping() {
        return this.printMapping;
    }

    public void setOutputMapping(@CheckForNull File outputMapping) {
        this.outputMapping = outputMapping;
    }

    public boolean shrink() {
        return this.shrink;
    }

    public boolean optimize() {
        return this.optimize;
    }

    public boolean preverify() {
        return this.preverify;
    }

    public void setObfuscate(boolean obfuscate) {
        this.obfuscate = obfuscate;
    }

    public boolean obfuscate() {
        return this.obfuscate;
    }

    public void setKeepParameterNames(boolean keepParameterNames) {
        this.keepParameterNames = keepParameterNames;
    }

    public boolean getKeepParameterNames() {
        assert (this.obfuscate);
        return this.keepParameterNames;
    }

    public void setObfuscationMapping(@CheckForNull File obfuscationMapping) {
        this.obfuscationMapping = obfuscationMapping;
    }

    public void setUseMixedCaseClassName(boolean useMixedCaseClassName) {
        this.useMixedCaseClassName = useMixedCaseClassName;
    }

    public void setUseUniqueClassMemberNames(boolean useUniqueClassMemberNames) {
        this.useUniqueClassMemberNames = useUniqueClassMemberNames;
    }

    public void addInJars(@Nonnull List<File> inJars) {
        this.inJars.addAll(inJars);
    }

    public void addOutJars(@Nonnull List<File> outJars) {
        this.outJars.addAll(outJars);
    }

    public void addLibraryJars(@Nonnull String libraryJars) {
        this.libraryJars = this.libraryJars == null ? libraryJars : this.libraryJars + File.pathSeparatorChar + libraryJars;
    }

    public boolean getUseUniqueClassMemberNames() {
        return this.useUniqueClassMemberNames;
    }

    public boolean getUseMixedCaseClassName() {
        return this.useMixedCaseClassName;
    }

    @Nonnull
    public List<File> getInJars() {
        return this.inJars;
    }

    @Nonnull
    public List<File> getOutJars() {
        return this.outJars;
    }

    @CheckForNull
    public String getLibraryJars() {
        return this.libraryJars;
    }

    public File getObfuscationMapping() {
        return this.obfuscationMapping;
    }

    public File getOutputMapping() {
        return this.outputMapping;
    }

    public File getObfuscationDictionary() {
        return this.obfuscationDictionary;
    }

    public void setObfuscationDictionary(@CheckForNull File obfuscationDictionary) {
        this.obfuscationDictionary = obfuscationDictionary;
    }

    public File getPackageObfuscationDictionary() {
        return this.packageObfuscationDictionary;
    }

    public void setPackageObfuscationDictionary(@CheckForNull File packageObfuscationDictionary) {
        this.packageObfuscationDictionary = packageObfuscationDictionary;
    }

    public File getClassObfuscationDictionary() {
        return this.classObfuscationDictionary;
    }

    public void setClassObfuscationDictionary(@CheckForNull File classObfuscationDictionary) {
        this.classObfuscationDictionary = classObfuscationDictionary;
    }

    public void setPackageForRenamedClasses(@CheckForNull String packageForRenamedClasses) {
        this.packageForRenamedClasses = packageForRenamedClasses;
        if (packageForRenamedClasses != null) {
            this.packageForFlatHierarchy = null;
        }
    }

    @CheckForNull
    public String getPackageForRenamedClasses() {
        return this.packageForRenamedClasses;
    }

    public void setPackageForFlatHierarchy(@CheckForNull String packageForFlatHierarchy) {
        if (this.packageForRenamedClasses == null) {
            this.packageForFlatHierarchy = packageForFlatHierarchy;
        } else assert (this.packageForFlatHierarchy == null);
    }

    @CheckForNull
    public String getPackageForFlatHierarchy() {
        return this.packageForFlatHierarchy;
    }

    @Nonnull
    public List<ClassSpecification> getKeepClassSpecs() {
        return this.keepClassSpecs;
    }

    @Nonnull
    public List<ClassSpecification> getKeepClassesWithMembersSpecs() {
        return this.keepClassesWithMembersSpecs;
    }

    @Nonnull
    public List<ClassSpecification> getKeepClassMembersSpecs() {
        return this.keepClassMembersSpecs;
    }

    public void addKeepClassSpecification(@CheckForNull ClassSpecification classSpecification) {
        assert (classSpecification != null);
        this.keepClassSpecs.add(classSpecification);
    }

    public void addKeepClassesWithMembers(@CheckForNull ClassSpecification classSpecification) {
        assert (classSpecification != null);
        this.keepClassesWithMembersSpecs.add(classSpecification);
    }

    public void addKeepClassMembers(@CheckForNull ClassSpecification classSpecification) {
        assert (classSpecification != null);
        this.keepClassMembersSpecs.add(classSpecification);
    }

    public void addAllKeepAttribute(@Nonnull List<FilterSpecification> attribute) {
        this.keepAttributes.addAll(attribute);
    }

    public void addAllKeepPackageName(@Nonnull List<FilterSpecification> packageSpec) {
        this.keepPackageNames.addAll(packageSpec);
    }

    @Nonnull
    public List<FilterSpecification> getKeepPackageNames() {
        return this.keepPackageNames;
    }

    public void addKeepPackageNames(@Nonnull NameSpecification packageName, boolean negator) {
        this.keepPackageNames.add(new FilterSpecification(packageName, negator));
    }

    public static <T> boolean matches(@Nonnull List<? extends Specification<T>> specifications, @Nonnull T value) {
        for (Specification<T> spec : specifications) {
            if (!spec.matches(value)) continue;
            return true;
        }
        return false;
    }

    public boolean keepAttribute(@Nonnull String attributeName) {
        assert (this.obfuscate);
        return Flags.matches(this.keepAttributes, attributeName);
    }

    public void setRenameSourceFileAttribute(@CheckForNull String renameSourceFileAttribute) {
        this.renameSourceFileAttribute = renameSourceFileAttribute;
    }

    @CheckForNull
    public String getRenameSourceFileAttribute() {
        return this.renameSourceFileAttribute;
    }

    @Nonnull
    public List<FilterSpecification> getAdaptClassStrings() {
        return this.adaptClassStrings;
    }

    public void addAdaptClassStrings(@Nonnull List<FilterSpecification> adaptClassStrings) {
        this.adaptClassStrings.addAll(adaptClassStrings);
    }

    public boolean printSeeds() {
        return this.printSeeds;
    }

    public void setPrintSeeds(boolean printSeeds) {
        this.printSeeds = printSeeds;
    }

    @CheckForNull
    public File getSeedsFile() {
        return this.seedsFile;
    }

    public void setSeedsFile(@CheckForNull File seedsFile) {
        this.seedsFile = seedsFile;
    }

    public void adaptResourceFileNames(@Nonnull List<FilterSpecification> filter) {
        this.adaptResourceFileNames.addAll(filter);
    }

    @Nonnull
    public List<FilterSpecification> getAdaptResourceFileNames() {
        return this.adaptResourceFileNames;
    }

    public void adaptResourceFileContents(@Nonnull List<FilterSpecification> filter) {
        this.adaptResourceFileContents.addAll(filter);
    }

    @Nonnull
    public List<FilterSpecification> getAdaptResourceFileContents() {
        return this.adaptResourceFileContents;
    }
}

