/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.shrink;

import com.android.jack.ir.ast.JSession;
import com.android.jack.reporting.ReportableIOException;
import com.android.jack.reporting.Reporter;
import com.android.jack.shrob.shrink.StructurePrinting;
import com.android.jack.util.StructurePrinter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Produce;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.util.codec.WriterFileCodec;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.BooleanPropertyId;
import com.android.sched.util.config.id.WriterFilePropertyId;
import com.android.sched.util.file.CannotWriteException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.stream.CustomPrintWriter;
import java.io.IOException;
import javax.annotation.Nonnull;

@HasKeyId
@Description(value="lists all members and types")
@Produce(value={StructurePrinting.class})
public class ShrinkStructurePrinter
implements RunnableSchedulable<JSession> {
    @Nonnull
    public static final BooleanPropertyId STRUCTURE_PRINTING = BooleanPropertyId.create("jack.internal.structure.print", "List all types and members").addDefaultValue(Boolean.FALSE);
    @Nonnull
    public static final WriterFilePropertyId STRUCTURE_PRINTING_FILE = WriterFilePropertyId.create("jack.internal.structure.print.file", "File containing the list of all types and members", new WriterFileCodec(FileOrDirectory.Existence.MAY_EXIST).allowStandardOutputOrError().allowCharset()).addDefaultValue("-").requiredIf(STRUCTURE_PRINTING.getValue().isTrue());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(@Nonnull JSession session) {
        CustomPrintWriter writer = ThreadConfig.get(STRUCTURE_PRINTING_FILE).getPrintWriter();
        try {
            StructurePrinter visitor = new StructurePrinter(writer);
            visitor.accept(session.getTypesToEmit());
        }
        finally {
            writer.close();
            try {
                writer.throwPendingException();
            }
            catch (IOException e) {
                session.getReporter().report(Reporter.Severity.FATAL, new ReportableIOException("Structure", new CannotWriteException(ThreadConfig.get(STRUCTURE_PRINTING_FILE), (Throwable)e)));
                session.abortEventually();
            }
        }
    }
}

