/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.shrink;

import com.android.jack.analysis.tracer.AbstractTracerBrush;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JDefinedInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JPhantomClass;
import com.android.jack.ir.ast.JPhantomClassOrInterface;
import com.android.jack.ir.ast.JPhantomInterface;
import com.android.jack.library.DumpInLibrary;
import com.android.jack.shrob.seed.SeedMarker;
import com.android.jack.shrob.shrink.KeepMarker;
import com.android.jack.shrob.shrink.PartialTypeHierarchy;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.BooleanPropertyId;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

@Description(value="Marks all classes and members that will be kept when shrinking.")
@Transform(add={KeepMarker.class, PartialTypeHierarchy.class})
@Constraint(need={SeedMarker.class})
@HasKeyId
public class KeeperBrush
extends AbstractTracerBrush<KeepMarker> {
    @Nonnull
    public static final BooleanPropertyId KEEP_ENCLOSING_METHOD = BooleanPropertyId.create("jack.shrink.keep.enclosing.method", "Keep the enclosing method of anonymous classes").addDefaultValue(Boolean.FALSE).addCategory(DumpInLibrary.class);

    public KeeperBrush() {
        super(ThreadConfig.get(KEEP_ENCLOSING_METHOD), KeepMarker.class, SeedMarker.class);
    }

    @Override
    protected boolean mustTraceOverridingMethod(@Nonnull JMethod method) {
        if (!method.getEnclosingType().isToEmit()) {
            return true;
        }
        return super.mustTraceOverridingMethod(method);
    }

    @Override
    @Nonnull
    protected KeepMarker createMarkerFor(@Nonnull JNode node) {
        return new KeepMarker();
    }

    @Override
    protected boolean isMarked(@Nonnull JNode node) {
        if (node instanceof JDefinedClassOrInterface && !((JDefinedClassOrInterface)node).isToEmit()) {
            return true;
        }
        if (node instanceof JMethod && !((JMethod)node).getEnclosingType().isToEmit()) {
            return true;
        }
        return super.isMarked(node);
    }

    @Override
    public void setMustTraceOverridingMethods(@Nonnull JMethod method) {
        if (method.getEnclosingType().isToEmit()) {
            super.setMustTraceOverridingMethods(method);
        }
    }

    @Override
    protected boolean markIfNecessary(@Nonnull JNode node) {
        JDefinedClassOrInterface jdcoi = node instanceof JDefinedClassOrInterface ? (JDefinedClassOrInterface)node : node.getParent(JDefinedClassOrInterface.class);
        if (!jdcoi.isToEmit()) {
            return false;
        }
        return super.markIfNecessary(node);
    }

    @Override
    public boolean startTraceSeed(@Nonnull JDefinedClassOrInterface type) {
        SeedMarker marker = type.getMarker(SeedMarker.class);
        return marker != null && !marker.getModifier().allowShrinking();
    }

    @Override
    public boolean startTraceSeed(@Nonnull JMethod method) {
        SeedMarker marker = method.getMarker(SeedMarker.class);
        return marker != null && !marker.getModifier().allowShrinking();
    }

    @Override
    public boolean startTraceSeed(@Nonnull JField field) {
        SeedMarker marker = field.getMarker(SeedMarker.class);
        return marker != null && !marker.getModifier().allowShrinking();
    }

    @Override
    public boolean startTrace(@Nonnull JDefinedClassOrInterface type) {
        boolean traceType = this.markIfNecessary(type);
        if (traceType) {
            ArrayList<JPhantomClassOrInterface> unknownTypes = new ArrayList<JPhantomClassOrInterface>();
            if (type instanceof JDefinedClass) {
                this.findUnknownTypes((JDefinedClass)type, unknownTypes);
            } else {
                assert (type instanceof JDefinedInterface);
                this.findUnknownTypes(type.getImplements(), unknownTypes);
            }
            if (!unknownTypes.isEmpty()) {
                type.addMarker(new PartialTypeHierarchy(type, unknownTypes));
            }
        }
        return traceType;
    }

    private void findUnknownTypes(@Nonnull JDefinedClass t, @Nonnull List<JPhantomClassOrInterface> unknownTypes) {
        JClass superClass = t.getSuperClass();
        if (superClass instanceof JPhantomClass) {
            unknownTypes.add((JPhantomClass)superClass);
        } else if (superClass != null) {
            this.findUnknownTypes((JDefinedClass)superClass, unknownTypes);
        }
        this.findUnknownTypes(t.getImplements(), unknownTypes);
    }

    private void findUnknownTypes(@Nonnull List<JInterface> interfaces, @Nonnull List<JPhantomClassOrInterface> unknownTypes) {
        for (JInterface jInterface : interfaces) {
            if (jInterface instanceof JPhantomInterface) {
                unknownTypes.add((JPhantomInterface)jInterface);
                continue;
            }
            assert (jInterface instanceof JDefinedInterface);
            this.findUnknownTypes(((JDefinedInterface)jInterface).getImplements(), unknownTypes);
        }
    }
}

