/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.obfuscation.resource;

import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.file.CannotDeleteFileException;
import com.android.sched.util.file.CannotGetModificationTimeException;
import com.android.sched.util.file.CannotReadException;
import com.android.sched.util.file.CannotWriteException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.HasLocation;
import com.android.sched.util.location.Location;
import com.android.sched.util.stream.LocationByteStreamSucker;
import com.android.sched.vfs.VFile;
import com.android.sched.vfs.VPath;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.attribute.FileTime;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class RefinedVFile
implements VFile {
    @Nonnull
    private final VFile file;
    @Nonnull
    private final TreeSet<RefinedEntry> refinedEntries = new TreeSet<RefinedEntry>(new Comparator<RefinedEntry>(){

        @Override
        public int compare(@Nonnull RefinedEntry e1, @Nonnull RefinedEntry e2) {
            return e1.startPosition > e2.startPosition ? 1 : (e1.endPosition < e2.startPosition ? -1 : 0);
        }
    });

    public RefinedVFile(@Nonnull VFile file) {
        this.file = file;
    }

    public void addRefinedEntry(@Nonnegative int startPosition, @Nonnegative int endPosition, @Nonnull CharSequence content) {
        this.refinedEntries.add(new RefinedEntry(startPosition, endPosition, content));
    }

    @Override
    @Nonnull
    public InputStream getInputStream() throws WrongPermissionException {
        InputStream inputStream = this.file.getInputStream();
        if (this.refinedEntries.isEmpty()) {
            return inputStream;
        }
        return new RefinedInputStream(inputStream);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.file.getName();
    }

    @Override
    @Nonnull
    public Location getLocation() {
        return this.file.getLocation();
    }

    @Override
    public boolean isVDir() {
        return false;
    }

    @Override
    public void delete() throws CannotDeleteFileException {
        this.file.delete();
    }

    @Override
    @Nonnull
    public VPath getPath() {
        return this.file.getPath();
    }

    @Override
    @Nonnull
    public VPath getPathFromRoot() {
        return this.file.getPathFromRoot();
    }

    @Override
    @Nonnull
    public FileTime getLastModified() throws CannotGetModificationTimeException {
        return this.file.getLastModified();
    }

    @Override
    @Nonnull
    public OutputStream getOutputStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public OutputStream getOutputStream(boolean append) {
        throw new UnsupportedOperationException();
    }

    @Override
    @CheckForNull
    public String getDigest() {
        return null;
    }

    @Override
    public void copy(@Nonnull VFile vFile) throws WrongPermissionException, CannotCloseException, CannotReadException, CannotWriteException {
        try (InputStream is = this.getInputStream();){
            try (OutputStream os = vFile.getOutputStream();){
                new LocationByteStreamSucker(is, os, this, vFile).suck();
            }
            catch (IOException e) {
                throw new CannotCloseException((HasLocation)vFile, (Exception)e);
            }
        }
        catch (IOException e) {
            throw new CannotCloseException((HasLocation)this, (Exception)e);
        }
    }

    private class RefinedInputStream
    extends InputStream {
        @Nonnull
        private final InputStream baseInputStream;
        private int position = -1;
        @CheckForNull
        private InputStream currentStream;
        @CheckForNull
        private RefinedEntry currentRefinedEntry;
        @Nonnull
        private final Iterator<RefinedEntry> refinedEntryIterator;

        public RefinedInputStream(InputStream baseInputStream) {
            this.baseInputStream = baseInputStream;
            this.refinedEntryIterator = RefinedVFile.this.refinedEntries.iterator();
            if (this.refinedEntryIterator.hasNext()) {
                this.currentRefinedEntry = this.refinedEntryIterator.next();
            }
        }

        @Override
        public int read() throws IOException {
            if (this.currentStream != null) {
                int inputData = this.currentStream.read();
                if (inputData == -1) {
                    this.closeCurrentRefinedEntry();
                } else {
                    return inputData;
                }
            }
            if (this.openNextRefinedEntryIfNecessary()) {
                assert (this.currentStream != null);
                return this.currentStream.read();
            }
            ++this.position;
            return this.baseInputStream.read();
        }

        private boolean openNextRefinedEntryIfNecessary() {
            assert (this.currentStream == null);
            if (this.currentRefinedEntry != null && this.currentRefinedEntry.startPosition <= this.position + 1) {
                assert (this.currentRefinedEntry.endPosition >= this.position);
                this.currentStream = this.currentRefinedEntry.openRead();
                return true;
            }
            return false;
        }

        private void closeCurrentRefinedEntry() throws IOException {
            assert (this.currentStream != null);
            this.currentStream.close();
            this.currentStream = null;
            assert (this.currentRefinedEntry != null);
            int toSkip = this.currentRefinedEntry.endPosition - this.position;
            while (toSkip > 0) {
                assert (this.baseInputStream.available() != 0);
                toSkip = (int)((long)toSkip - this.baseInputStream.skip(toSkip));
            }
            this.position = this.currentRefinedEntry.endPosition;
            this.currentRefinedEntry = this.refinedEntryIterator.hasNext() ? this.refinedEntryIterator.next() : null;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.available() == 0) {
                return -1;
            }
            int totalRead = 0;
            while (this.available() != 0 && totalRead < len) {
                int baseLength;
                int read;
                if (this.currentStream != null) {
                    int read2 = this.currentStream.read(b, off + totalRead, len - totalRead);
                    if (read2 > 0) {
                        totalRead += read2;
                    }
                    if (this.currentStream.available() == 0) {
                        this.closeCurrentRefinedEntry();
                    }
                }
                if ((read = this.baseInputStream.read(b, off + totalRead, baseLength = this.currentRefinedEntry != null ? Math.min(this.currentRefinedEntry.startPosition - (this.position + 1), len - totalRead) : len - totalRead)) > 0) {
                    totalRead += read;
                    this.position += read;
                }
                if (totalRead >= len) continue;
                this.openNextRefinedEntryIfNecessary();
            }
            return totalRead;
        }

        @Override
        public int available() throws IOException {
            int available = 0;
            if (this.currentStream != null) {
                available += this.currentStream.available();
            }
            if (this.baseInputStream.available() > 0) {
                ++available;
            }
            return available;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.baseInputStream.close();
        }
    }

    private static class RefinedEntry {
        @Nonnegative
        private final int startPosition;
        @Nonnegative
        private final int endPosition;
        @Nonnull
        private final CharSequence content;

        private RefinedEntry(@Nonnegative int startPosition, @Nonnegative int endPosition, @Nonnull CharSequence content) {
            this.startPosition = startPosition;
            this.endPosition = endPosition;
            this.content = content;
        }

        @Nonnull
        public InputStream openRead() {
            return new ByteArrayInputStream(this.content.toString().getBytes());
        }

        public String toString() {
            return this.startPosition + ":" + this.endPosition;
        }
    }
}

