/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.obfuscation;

import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.shrob.obfuscation.NewFieldNameMarker;
import com.android.jack.shrob.obfuscation.OneTimeHierarchyVisitor;
import com.android.jack.shrob.obfuscation.Renamer;
import javax.annotation.Nonnull;

public class FieldInHierarchyFinderVisitor
extends OneTimeHierarchyVisitor {
    @Nonnull
    private final String fieldName;
    private boolean hasFoundField = false;

    private FieldInHierarchyFinderVisitor(@Nonnull String fieldName) {
        this.fieldName = fieldName;
    }

    public void startVisit(@Nonnull JDefinedClassOrInterface type) {
        for (JField field : type.getFields()) {
            if (!field.isPrivate() || Renamer.mustBeRenamed(field.getId()) || !field.getName().equals(this.fieldName)) continue;
            this.hasFoundField = true;
            return;
        }
        this.visitSuperTypes(type);
        this.visitSubTypes(type);
    }

    @Override
    public boolean doAction(@Nonnull JDefinedClassOrInterface type) {
        NewFieldNameMarker marker = type.getMarker(NewFieldNameMarker.class);
        if (marker != null && marker.getNewNames().contains(this.fieldName)) {
            this.hasFoundField = true;
            return false;
        }
        for (JField field : type.getFields()) {
            if (field.isPrivate() || Renamer.mustBeRenamed(field.getId()) || !field.getName().equals(this.fieldName)) continue;
            this.hasFoundField = true;
            return false;
        }
        return true;
    }

    public static boolean containsFieldKey(@Nonnull String name, @Nonnull JField field) {
        FieldInHierarchyFinderVisitor visitor = new FieldInHierarchyFinderVisitor(name);
        visitor.startVisit(field.getEnclosingType());
        return visitor.hasFoundField;
    }
}

