/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.obfuscation;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JFieldId;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.shrob.obfuscation.MappingApplier;
import com.android.jack.shrob.obfuscation.OriginalNameMarker;
import com.android.jack.shrob.obfuscation.Renamer;
import com.android.jack.shrob.proguard.GrammarActions;
import com.android.jack.transformations.request.TransformationRequest;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nonnull;

public class CollectingMappingApplier
extends MappingApplier {
    @Nonnull
    private final Map<String, String> fieldNames = new HashMap<String, String>();
    @Nonnull
    private final Map<String, String> methodNames = new HashMap<String, String>();

    @Nonnull
    public Map<String, String> getFieldNames() {
        return this.fieldNames;
    }

    @Nonnull
    public Map<String, String> getMethodNames() {
        return this.methodNames;
    }

    public CollectingMappingApplier(@Nonnull TransformationRequest request) {
        super(request);
    }

    @Override
    protected void renameField(@Nonnull JField field, @Nonnull File mappingFile, int lineNumber, @Nonnull String newName) {
        JFieldId id = field.getId();
        if (!id.containsMarker(OriginalNameMarker.class)) {
            super.renameField(field, mappingFile, lineNumber, newName);
            String oldName = id.getName();
            String previousNewName = this.fieldNames.get(oldName);
            if (previousNewName != null && !previousNewName.equals(newName)) {
                logger.log(Level.WARNING, "{0}:{1}: Cannot rename field {2} in {3} to {4} because it has already been mapped to {5}", new Object[]{mappingFile.getPath(), lineNumber, oldName, Jack.getUserFriendlyFormatter().getName(field.getEnclosingType()), previousNewName, newName});
            } else {
                this.fieldNames.put(Renamer.getFieldKey(id), newName);
            }
        }
    }

    @Override
    protected void renameMethod(@Nonnull JMethod method, @Nonnull File mappingFile, int lineNumber, @Nonnull String newName) {
        JMethodIdWide id = method.getMethodIdWide();
        if (!id.containsMarker(OriginalNameMarker.class)) {
            super.renameMethod(method, mappingFile, lineNumber, newName);
            if (this.methodNames != null) {
                String methodSignature = GrammarActions.getSignatureFormatter().getName(method);
                String previousNewName = this.methodNames.get(methodSignature);
                if (previousNewName != null && !previousNewName.equals(newName)) {
                    logger.log(Level.WARNING, "{0}:{1}: Cannot rename method {2} in {3} to {4} because it has already been mapped to {5}", new Object[]{mappingFile.getPath(), lineNumber, Jack.getUserFriendlyFormatter().getName(method), Jack.getUserFriendlyFormatter().getName(method.getEnclosingType()), previousNewName, newName});
                } else {
                    this.methodNames.put(methodSignature, newName);
                }
            }
        }
    }
}

