/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.scheduling.marker.collector;

import com.android.jack.ir.ast.JNode;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@Description(value="SubTreeMarkers")
@ValidOn(value={JNode.class})
public abstract class SubTreeMarkers<T extends Marker>
implements Marker {
    private static final int SUB_TREE_NOT_COMPLETELY_ANALYZED = -1;
    private int positionOfNestedMarkersEnd = -1;
    @Nonnull
    private final List<T> markers = new ArrayList<T>();
    @Nonnegative
    private int beforeMarkerEndPosition;
    @Nonnegative
    private int afterMakerStartPosition;
    @Nonnull
    private final Class<T> classOfMarker;

    public SubTreeMarkers(@Nonnull Class<T> classOfMarker) {
        this.classOfMarker = classOfMarker;
    }

    @Override
    public Marker cloneIfNeeded() {
        throw new AssertionError((Object)(this.getClass().getName() + " must not be cloned."));
    }

    void endOfNestedMarkers() {
        this.positionOfNestedMarkersEnd = this.markers.size();
    }

    void addMarker(@Nonnull T marker) {
        this.markers.add(marker);
    }

    void addMarkers(@Nonnull List<T> markers) {
        this.markers.addAll(markers);
    }

    boolean isCompletelyAnalyzed() {
        return this.positionOfNestedMarkersEnd != -1;
    }

    @Nonnegative
    int getPositionOfNestedMarkerEnd() {
        assert (this.positionOfNestedMarkersEnd >= 0);
        return this.positionOfNestedMarkersEnd;
    }

    @Nonnull
    List<T> getAllMarkers() {
        return this.markers;
    }

    @Nonnull
    Class<T> getClassOfCollectedMarkers() {
        return this.classOfMarker;
    }

    @Nonnegative
    void setBeforeMarkerEndPosition(@Nonnegative int beforeMarkerEndPosition) {
        this.beforeMarkerEndPosition = beforeMarkerEndPosition;
    }

    @Nonnegative
    void setAfterMakerStartPosition(@Nonnegative int afterMakerStartPosition) {
        this.afterMakerStartPosition = afterMakerStartPosition;
    }

    @Nonnegative
    int getBeforeMarkerEndPosition() {
        return this.beforeMarkerEndPosition;
    }

    @Nonnegative
    int getAfterMarkerStartPosition() {
        return this.afterMakerStartPosition;
    }
}

