/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.reporting;

import com.android.jack.Options;
import com.android.sched.util.codec.VariableName;
import javax.annotation.Nonnull;

public interface Reportable {
    @Nonnull
    public String getMessage();

    @Nonnull
    public ProblemLevel getDefaultProblemLevel();

    @VariableName(value="level")
    public static enum ProblemLevel {
        ERROR(Options.VerbosityLevel.ERROR),
        WARNING(Options.VerbosityLevel.WARNING),
        INFO(Options.VerbosityLevel.INFO);

        @Nonnull
        private final Options.VerbosityLevel verbosityLevelThreshold;

        private ProblemLevel(Options.VerbosityLevel verbosityLevelThreshold) {
            this.verbosityLevelThreshold = verbosityLevelThreshold;
        }

        public boolean isVisibleWith(@Nonnull Options.VerbosityLevel verbosityLevel) {
            return verbosityLevel.ordinal() >= this.verbosityLevelThreshold.ordinal();
        }
    }
}

