/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.reflection;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JDefinedInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.formatter.TypePackageAndMethodFormatter;
import com.android.jack.reflection.MultipleFieldsFoundException;
import com.android.jack.reflection.MultipleMethodsFoundException;
import com.android.sched.util.log.LoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class MemberFinder {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();

    @CheckForNull
    public static JField getDirectField(@Nonnull JDefinedClassOrInterface declaringType, @Nonnull String name) {
        JField fieldFound = null;
        for (JField field : declaringType.getFields(name)) {
            if (!field.isPublic()) continue;
            if (fieldFound != null) {
                MemberFinder.throwMultipleFieldError(declaringType, name);
            }
            fieldFound = field;
        }
        return fieldFound;
    }

    @CheckForNull
    public static JField getField(@Nonnull JDefinedClassOrInterface declaringType, @Nonnull String name) {
        JField fieldFound = MemberFinder.getDirectField(declaringType, name);
        if (fieldFound != null) {
            return fieldFound;
        }
        for (JInterface interfaceType : declaringType.getImplements()) {
            if (!(interfaceType instanceof JDefinedInterface) || (fieldFound = MemberFinder.getField((JDefinedInterface)interfaceType, name)) == null) continue;
            return fieldFound;
        }
        JClass superClass = declaringType.getSuperClass();
        if (superClass instanceof JDefinedClass) {
            fieldFound = MemberFinder.getField((JDefinedClass)superClass, name);
        }
        return fieldFound;
    }

    @CheckForNull
    public static JMethod getDirectMethod(@Nonnull JDefinedClassOrInterface declaringType, @Nonnull String methodNameWithParam) {
        JMethod methodFound = null;
        TypePackageAndMethodFormatter formatter = Jack.getLookupFormatter();
        for (JMethod m : declaringType.getMethods()) {
            if (!formatter.getName(m).startsWith(methodNameWithParam) || !m.isPublic()) continue;
            if (methodFound != null) {
                MemberFinder.throwMultipleMethodError(declaringType, methodNameWithParam);
                continue;
            }
            methodFound = m;
        }
        return methodFound;
    }

    @CheckForNull
    public static JMethod getMethod(@Nonnull JDefinedClassOrInterface declaringType, @Nonnull String methodNameWithParam) {
        JMethod methodFound = MemberFinder.getDirectMethod(declaringType, methodNameWithParam);
        if (methodFound != null) {
            return methodFound;
        }
        JClass superClass = declaringType.getSuperClass();
        if (superClass instanceof JDefinedClass && (methodFound = MemberFinder.getMethod((JDefinedClass)superClass, methodNameWithParam)) != null) {
            return methodFound;
        }
        for (JInterface interfaceType : declaringType.getImplements()) {
            if (!(interfaceType instanceof JDefinedInterface) || (methodFound = MemberFinder.getMethod((JDefinedInterface)interfaceType, methodNameWithParam)) == null) continue;
            return methodFound;
        }
        return null;
    }

    private static void throwMultipleFieldError(@Nonnull JDefinedClassOrInterface declaringType, @Nonnull String name) {
        String typeString = Jack.getUserFriendlyFormatter().getName(declaringType);
        logger.log(Level.SEVERE, "Multiple fields found for dynamically referenced field {0} in type {1}", new Object[]{name, typeString});
        throw new MultipleFieldsFoundException("Multiple fields found for dynamically referenced field " + name + " in type " + typeString);
    }

    private static void throwMultipleMethodError(@Nonnull JDefinedClassOrInterface declaringType, @Nonnull String name) {
        String typeString = Jack.getUserFriendlyFormatter().getName(declaringType);
        logger.log(Level.SEVERE, "Multiple methods found for dynamically referenced method {0} in type {1}", new Object[]{name, typeString});
        throw new MultipleMethodsFoundException("Multiple methods found for dynamically referenced method " + name + " in type " + typeString);
    }
}

