/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.preprocessor;

import com.android.jack.ir.ast.HasModifier;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.preprocessor.BooleanExpression;
import com.android.jack.preprocessor.ClassMembersScope;
import com.android.jack.preprocessor.Context;
import com.android.jack.preprocessor.Expression;
import com.android.jack.preprocessor.ExtendsScope;
import com.android.jack.preprocessor.NamePattern;
import com.android.jack.preprocessor.Scope;
import com.android.jack.preprocessor.SubContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;

public class ClassFilter
implements Expression<Collection<JClassOrInterface>, Scope> {
    @Nonnull
    private final NamePattern name;
    @Nonnull
    private Expression<Boolean, HasModifier> modifierExpression = BooleanExpression.getTrue();
    @Nonnull
    private Expression<Boolean, Scope> extendExpression = BooleanExpression.getTrue();
    @Nonnull
    private Expression<Boolean, Scope> containsExpression = BooleanExpression.getTrue();
    @Nonnull
    private Collection<Expression<Collection<?>, Scope>> annotateSets = Collections.emptyList();

    public ClassFilter(NamePattern name) {
        this.name = name;
    }

    @Override
    @Nonnull
    public Collection<JClassOrInterface> eval(@Nonnull Scope scope, @Nonnull Context context) {
        ArrayList<JClassOrInterface> nodes = new ArrayList<JClassOrInterface>();
        for (JClassOrInterface coi : scope.getNodesByName(JClassOrInterface.class, this.name)) {
            if (coi instanceof JDefinedClassOrInterface) {
                ClassMembersScope membersScope;
                ExtendsScope extendsScope;
                JDefinedClassOrInterface jdcoi = (JDefinedClassOrInterface)coi;
                SubContext subContext = new SubContext(context);
                if (!this.modifierExpression.eval(jdcoi, subContext).booleanValue() || !this.extendExpression.eval(extendsScope = new ExtendsScope(jdcoi), subContext).booleanValue() || !this.containsExpression.eval(membersScope = new ClassMembersScope(jdcoi), subContext).booleanValue()) continue;
                nodes.add(coi);
                subContext.push();
                for (Expression<Collection<?>, Scope> set : this.annotateSets) {
                    set.eval(membersScope, context);
                }
                continue;
            }
            if (this.modifierExpression != BooleanExpression.TRUE || this.extendExpression != BooleanExpression.TRUE || this.containsExpression != BooleanExpression.TRUE) continue;
            nodes.add(coi);
        }
        return nodes;
    }

    public void setExtendsExpression(@Nonnull Expression<Boolean, Scope> expression) {
        this.extendExpression = expression;
    }

    public void setContainsExpression(@Nonnull Expression<Boolean, Scope> expression) {
        this.containsExpression = expression;
    }

    public void setAnnotateSets(@Nonnull Collection<Expression<Collection<?>, Scope>> sets) {
        this.annotateSets = sets;
    }

    public void setModifierExpression(@Nonnull Expression<Boolean, HasModifier> expression) {
        this.modifierExpression = expression;
    }

    @Nonnull
    public String toString() {
        return "class " + this.name.toString();
    }
}

