/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.plugin;

import com.android.jack.plugin.PluginFilter;
import com.android.jack.plugin.v01.Plugin;
import com.android.sched.util.SubReleaseKind;
import com.android.sched.util.UncomparableSubReleaseKind;
import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.log.LoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

@ImplementationName(iface=PluginFilter.class, name="stable-only")
public class StableOnly
implements PluginFilter {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();

    @Override
    public boolean accept(@Nonnull Plugin plugin) {
        try {
            boolean accepted = plugin.getVersion().getSubReleaseKind().isMoreStableThan(SubReleaseKind.CANDIDATE);
            if (accepted) {
                logger.log(Level.INFO, "For plugin ''{0}'', accepted version {1} because stable", new Object[]{plugin.getCanonicalName(), plugin.getVersion().getVersion()});
            } else {
                logger.log(Level.INFO, "For plugin ''{0}'', rejected version {1} because not stable", new Object[]{plugin.getCanonicalName(), plugin.getVersion().getVersion()});
            }
            return accepted;
        }
        catch (UncomparableSubReleaseKind e) {
            logger.log(Level.INFO, "For plugin ''{0}'', rejected version {1} because not stable", new Object[]{plugin.getCanonicalName(), plugin.getVersion().getVersion()});
            return false;
        }
    }
}

