/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.wofr;

import com.android.jack.ir.ast.JField;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;

@Description(value="Represents counts of field reads and writes")
@ValidOn(value={JField.class})
public class FieldReadWriteCountsMarker
implements Marker {
    @Nonnull
    private final AtomicBoolean hasReads = new AtomicBoolean(false);
    @Nonnull
    private final AtomicInteger writesCount = new AtomicInteger();
    @Nonnull
    private final AtomicBoolean hasNonLiteralWrites = new AtomicBoolean(false);

    public static void markRead(@Nonnull JField field) {
        FieldReadWriteCountsMarker.getOrCreate((JField)field).hasReads.set(true);
    }

    public static void markWrite(@Nonnull JField field, boolean isNonLiteral) {
        FieldReadWriteCountsMarker marker = FieldReadWriteCountsMarker.getOrCreate(field);
        marker.writesCount.incrementAndGet();
        if (isNonLiteral) {
            marker.hasNonLiteralWrites.set(true);
        }
    }

    public static void unmarkWrite(@Nonnull JField field) {
        FieldReadWriteCountsMarker marker = field.getMarker(FieldReadWriteCountsMarker.class);
        assert (marker != null);
        marker.writesCount.decrementAndGet();
    }

    public static boolean hasReads(@Nonnull JField field) {
        FieldReadWriteCountsMarker marker = field.getMarker(FieldReadWriteCountsMarker.class);
        return marker != null && marker.hasReads.get();
    }

    public static boolean hasWrites(@Nonnull JField field) {
        FieldReadWriteCountsMarker marker = field.getMarker(FieldReadWriteCountsMarker.class);
        return marker != null && marker.writesCount.get() > 0;
    }

    public static boolean hasNonLiteralWrites(@Nonnull JField field) {
        FieldReadWriteCountsMarker marker = field.getMarker(FieldReadWriteCountsMarker.class);
        return marker != null && marker.hasNonLiteralWrites.get();
    }

    @Nonnull
    private static FieldReadWriteCountsMarker getOrCreate(@Nonnull JField field) {
        FieldReadWriteCountsMarker marker = field.getMarker(FieldReadWriteCountsMarker.class);
        if (marker != null) {
            return marker;
        }
        marker = new FieldReadWriteCountsMarker();
        FieldReadWriteCountsMarker existing = field.addMarkerIfAbsent(marker);
        return existing == null ? marker : existing;
    }

    @Override
    @Nonnull
    public Marker cloneIfNeeded() {
        throw new AssertionError();
    }
}

