/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.common;

import com.android.jack.ir.ast.JValueLiteral;
import com.android.jack.optimizations.common.LiteralValueListTracker;
import com.android.jack.optimizations.common.OptimizerUtils;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class SimpleLiteralValueListTracker
extends LiteralValueListTracker {
    @Nonnull
    private final JValueLiteral[] values;

    public SimpleLiteralValueListTracker(@Nonnegative int size) {
        this.values = new JValueLiteral[size];
    }

    @Override
    @Nonnegative
    public int size() {
        return this.values.length;
    }

    @Override
    @CheckForNull
    JValueLiteral getRawValue(@Nonnegative int index) {
        return this.values[index];
    }

    @Override
    void mergeWith(@Nonnegative int index, @CheckForNull JValueLiteral literal) {
        if (literal != null) {
            JValueLiteral value = this.values[index];
            if (value == null) {
                this.values[index] = literal;
            } else if (!this.isMultipleOrNonLiteralValue(value) && !OptimizerUtils.areSameValueLiterals(value, literal)) {
                this.values[index] = this.getMultipleOrNonLiteralValue();
            }
        }
    }
}

