/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.common;

import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JCatchBlock;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JLocalRef;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JValueLiteral;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.transformations.LocalVarCreator;
import com.android.jack.transformations.request.AppendBefore;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import java.util.ArrayList;
import javax.annotation.Nonnull;

@Transform(add={JAsgOperation.NonReusedAsg.class, JExpressionStatement.class, JLocalRef.class})
@Use(value={LocalVarCreator.class})
public class ExpressionReplaceHelper {
    @Nonnull
    private final LocalVarCreator varCreator;

    public ExpressionReplaceHelper(@Nonnull LocalVarCreator varCreator) {
        this.varCreator = varCreator;
    }

    public void replace(@Nonnull JExpression expr, @Nonnull JValueLiteral value, @Nonnull TransformationRequest request) {
        if (expr.canThrow() || !value.canThrow()) {
            request.append(new Replace(expr, value));
            return;
        }
        SourceInfo si = value.getSourceInfo();
        JStatement stmt = expr.getParent(JStatement.class);
        JLocal tmp = this.varCreator.createTempLocal(value.getType(), si, request);
        JAsgOperation assign = new JAsgOperation(si, tmp.makeRef(si), value);
        JExpressionStatement stmtAssignment = new JExpressionStatement(si, assign);
        stmtAssignment.setCatchBlocks(new ArrayList<JCatchBlock>(stmt.getJCatchBlocks()));
        request.append(new Replace(expr, tmp.makeRef(si)));
        request.append(new AppendBefore(stmt, stmtAssignment));
    }
}

