/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations;

import com.android.jack.analysis.DefinitionMarker;
import com.android.jack.cfg.BasicBlock;
import com.android.jack.cfg.BasicBlockMarker;
import com.android.jack.debug.DebugVariableInfoMarker;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JVariable;
import com.android.jack.ir.ast.JVariableRef;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.util.ThreeAddressCodeFormUtils;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Use;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Common part for simplification of definition uses chains and use definitions chains.")
@Use(value={ThreeAddressCodeFormUtils.class})
@Constraint(need={BasicBlockMarker.class})
public abstract class DefUsesAndUseDefsChainsSimplifier {
    @Nonnull
    protected JVariableRef getNewVarRef(@Nonnull JNode defExpr, @Nonnull SourceInfo sourceInfo) {
        assert (defExpr instanceof JVariableRef);
        JVariableRef newVarRef = ((JVariableRef)defExpr).getTarget().makeRef(sourceInfo);
        DebugVariableInfoMarker debugInfo = defExpr.getMarker(DebugVariableInfoMarker.class);
        if (debugInfo != null) {
            newVarRef.addMarker(debugInfo);
        }
        return newVarRef;
    }

    protected boolean hasLocalDef(@Nonnull JVariable var, @Nonnull BasicBlock basicBlock, @CheckForNull JStatement beginAfterStmt, @CheckForNull JStatement end) {
        return this.getLastLocalDef(var, basicBlock, beginAfterStmt, end) != null;
    }

    @CheckForNull
    protected DefinitionMarker getLastLocalDef(@Nonnull JVariable var, @Nonnull BasicBlock basicBlock, @CheckForNull JStatement beginAfterStmt, @CheckForNull JStatement end) {
        DefinitionMarker lastDefinition = null;
        List<JStatement> statements = basicBlock.getStatements();
        if (!statements.isEmpty()) {
            Iterator<JStatement> stmtIt = statements.iterator();
            JStatement stmt = null;
            if (beginAfterStmt != null) {
                assert (statements.contains(beginAfterStmt));
                while (stmt != beginAfterStmt) {
                    assert (stmtIt.hasNext());
                    stmt = stmtIt.next();
                }
            }
            while (stmtIt.hasNext() && (stmt = stmtIt.next()) != end) {
                assert (stmt != null);
                DefinitionMarker dm = ThreeAddressCodeFormUtils.getDefinitionMarker(stmt);
                if (dm == null || dm.getDefinedVariable() != var) continue;
                lastDefinition = dm;
            }
        }
        return lastDefinition;
    }
}

