/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.objectweb.asm.optimizer;

import com.android.jack.objectweb.asm.ClassReader;
import com.android.jack.objectweb.asm.ClassVisitor;
import com.android.jack.objectweb.asm.FieldVisitor;
import com.android.jack.objectweb.asm.MethodVisitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class JarOptimizer {
    static final Set<String> API = new HashSet<String>();
    static final Map<String, String> HIERARCHY = new HashMap<String, String>();
    static boolean nodebug = false;

    public static void main(String[] args) throws IOException {
        String line;
        File f = new File(args[0]);
        GZIPInputStream is = new GZIPInputStream(new FileInputStream(f));
        LineNumberReader lnr = new LineNumberReader(new InputStreamReader(is));
        while ((line = ((BufferedReader)lnr).readLine()) != null) {
            if (line.startsWith("class")) {
                String c = line.substring(6, line.lastIndexOf(32));
                String sc = line.substring(line.lastIndexOf(32) + 1);
                HIERARCHY.put(c, sc);
                continue;
            }
            API.add(line);
        }
        int argIndex = 1;
        if (args[argIndex].equals("-nodebug")) {
            nodebug = true;
            ++argIndex;
        }
        JarOptimizer.optimize(new File(args[argIndex]));
    }

    static void optimize(File f) throws IOException {
        if (nodebug && f.getName().contains("debug")) {
            return;
        }
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                JarOptimizer.optimize(files[i]);
            }
        } else if (f.getName().endsWith(".jar")) {
            File g = new File(f.getParentFile(), f.getName() + ".new");
            ZipFile zf = new ZipFile(f);
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(g));
            Enumeration<? extends ZipEntry> e = zf.entries();
            byte[] buf = new byte[10000];
            while (e.hasMoreElements()) {
                int n;
                ZipEntry ze = e.nextElement();
                if (ze.isDirectory()) {
                    out.putNextEntry(ze);
                    continue;
                }
                out.putNextEntry(ze);
                if (ze.getName().endsWith(".class")) {
                    ClassReader cr = new ClassReader(zf.getInputStream(ze));
                    cr.accept(new ClassVerifier(), 0);
                }
                InputStream is = zf.getInputStream(ze);
                do {
                    if ((n = is.read(buf, 0, buf.length)) == -1) continue;
                    out.write(buf, 0, n);
                } while (n != -1);
                out.closeEntry();
            }
            out.close();
            zf.close();
            if (!f.delete()) {
                throw new IOException("Cannot delete file " + f);
            }
            if (!g.renameTo(f)) {
                throw new IOException("Cannot rename file " + g);
            }
        }
    }

    static class ClassVerifier
    extends ClassVisitor {
        String owner;
        String method;

        public ClassVerifier() {
            super(327680);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.owner = name;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            this.method = name + desc;
            return new MethodVisitor(327680){

                public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                    ClassVerifier.this.check(owner, name);
                }

                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    ClassVerifier.this.check(owner, name + desc);
                }
            };
        }

        void check(String owner, String member) {
            if (owner.startsWith("java/")) {
                String o = owner;
                while (o != null) {
                    if (API.contains(o + ' ' + member)) {
                        return;
                    }
                    o = HIERARCHY.get(o);
                }
                System.out.println("WARNING: " + owner + ' ' + member + " called in " + this.owner + ' ' + this.method + " is not defined in JDK 1.3 API");
            }
        }
    }

    static class ClassDump
    extends ClassVisitor {
        String owner;

        public ClassDump() {
            super(327680);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.owner = name;
            if (this.owner.startsWith("java/")) {
                System.out.println("class " + name + ' ' + superName);
            }
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if (this.owner.startsWith("java/")) {
                System.out.println(this.owner + ' ' + name);
            }
            return null;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.owner.startsWith("java/")) {
                System.out.println(this.owner + ' ' + name + desc);
            }
            return null;
        }
    }
}

