/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.lookup;

import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.lookup.CommonTypes;
import com.android.jack.lookup.JLookup;
import javax.annotation.Nonnull;

class CommonTypesCache {
    private final JClassOrInterface[] commonTypes = new JClassOrInterface[CommonTypes.CommonType.values().length];
    private final JClass[] commonClasses = new JClass[CommonTypes.CommonType.values().length];
    private final JInterface[] commonInterfaces = new JInterface[CommonTypes.CommonType.values().length];
    @Nonnull
    private final JLookup lookup;

    CommonTypesCache(@Nonnull JLookup lookup) {
        this.lookup = lookup;
    }

    public JClass getClass(@Nonnull CommonTypes.CommonType type) throws JTypeLookupException {
        int typeOrdinal = type.ordinal();
        if (this.commonClasses[typeOrdinal] == null) {
            this.commonClasses[typeOrdinal] = this.lookup.getClass(type.getSignature());
        }
        return this.commonClasses[typeOrdinal];
    }

    public JInterface getInterface(@Nonnull CommonTypes.CommonType type) throws JTypeLookupException {
        int typeOrdinal = type.ordinal();
        if (this.commonInterfaces[typeOrdinal] == null) {
            this.commonInterfaces[typeOrdinal] = this.lookup.getInterface(type.getSignature());
        }
        return this.commonInterfaces[typeOrdinal];
    }

    public JType getType(@Nonnull CommonTypes.CommonType type) throws JTypeLookupException {
        int typeOrdinal = type.ordinal();
        if (this.commonTypes[typeOrdinal] == null) {
            this.commonTypes[typeOrdinal] = (JClassOrInterface)this.lookup.getType(type.getSignature());
        }
        return this.commonTypes[typeOrdinal];
    }
}

