/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.library;

import com.android.jack.Jack;
import com.android.jack.library.JackLibraryFactory;
import com.android.jack.library.OutputJackLibrary;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.Parser;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.codec.ZipFSCodec;
import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.OutputZipFile;
import com.android.sched.vfs.VFS;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class OutputJackLibraryCodec
implements StringCodec<OutputJackLibrary> {
    @Nonnull
    private final ZipFSCodec codec = new ZipFSCodec(FileOrDirectory.Existence.MAY_EXIST, OutputZipFile.Compression.UNCOMPRESSED);

    @Override
    @Nonnull
    public OutputJackLibrary parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return this.checkString(context, string);
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e);
        }
    }

    @Override
    @CheckForNull
    public OutputJackLibrary checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        VFS vfs = this.codec.checkString(context, string);
        return JackLibraryFactory.getOutputLibrary(vfs, Jack.getEmitterId(), Jack.getVersion().getVerboseVersion());
    }

    @Override
    @Nonnull
    public String getUsage() {
        return "a path to a jack library (" + this.codec.getDetailedUsage() + ")";
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return "jack";
    }

    @Override
    @Nonnull
    public List<Parser.ValueDescription> getValueDescriptions() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull OutputJackLibrary data) {
        return data.getPath();
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull OutputJackLibrary data) {
    }
}

