/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.library;

import com.android.jack.library.FileType;
import com.android.jack.library.InputJackLibrary;
import com.android.jack.library.InputJackLibraryCodec;
import com.android.jack.library.LibraryIOException;
import com.android.sched.util.HasDescription;
import com.android.sched.util.config.ConfigChecker;
import com.android.sched.util.config.MissingPropertyException;
import com.android.sched.util.config.PropertyIdException;
import com.android.sched.util.config.category.Category;
import com.android.sched.util.config.expression.BooleanExpression;
import com.android.sched.util.config.expression.LongExpression;
import com.android.sched.util.config.id.PropertyId;
import com.android.sched.util.log.LoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class InputJackLibraryPropertyId
extends PropertyId<InputJackLibrary>
implements HasDescription {
    @Nonnull
    private static Logger logger = LoggerFactory.getLogger();

    @Nonnull
    public static InputJackLibraryPropertyId create(@Nonnull String name, @Nonnull String description) {
        return new InputJackLibraryPropertyId(name, description, new InputJackLibraryCodec());
    }

    protected InputJackLibraryPropertyId(@Nonnull String name, @Nonnull String description, @Nonnull InputJackLibraryCodec codec) {
        super(name, description, codec);
        this.setShutdownHook(new PropertyId.ShutdownRunnable<InputJackLibrary>(){

            @Override
            public void run(@Nonnull InputJackLibrary lib) {
                try {
                    lib.close();
                }
                catch (LibraryIOException e) {
                    logger.log(Level.FINE, "Cannot close input jack library " + lib.getLocation().getDescription());
                }
            }
        });
    }

    @Nonnull
    public InputJackLibraryPropertyId addDefaultValue(@Nonnull String defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Nonnull
    public InputJackLibraryPropertyId addDefaultValue(@Nonnull InputJackLibrary defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Override
    @Nonnull
    public InputJackLibraryPropertyId requiredIf(@Nonnull BooleanExpression expression) {
        super.requiredIf(expression);
        return this;
    }

    @Nonnull
    public InputJackLibraryPropertyId addCategory(@Nonnull Class<? extends Category> category) {
        super.addCategory((Class)category);
        return this;
    }

    @Override
    @Nonnull
    public InputJackLibraryPropertyId addCategory(@Nonnull Category category) {
        super.addCategory(category);
        return this;
    }

    @Nonnull
    public LongExpression getMajorVersion() {
        return new LongExpression(){

            @Override
            public long eval(@Nonnull ConfigChecker checker) throws PropertyIdException, MissingPropertyException {
                if (!InputJackLibraryPropertyId.this.isRequired(checker)) {
                    throw new MissingPropertyException(InputJackLibraryPropertyId.this);
                }
                return checker.parse(InputJackLibraryPropertyId.this).getMajorVersion();
            }

            @Override
            @Nonnull
            public String getDescription() {
                return "major version of " + this.formatPropertyName(InputJackLibraryPropertyId.this);
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) {
                return "major version of " + this.formatPropertyName(checker, InputJackLibraryPropertyId.this);
            }
        };
    }

    public LongExpression getMinorVersion() {
        return new LongExpression(){

            @Override
            public long eval(@Nonnull ConfigChecker checker) throws PropertyIdException, MissingPropertyException {
                if (!InputJackLibraryPropertyId.this.isRequired(checker)) {
                    throw new MissingPropertyException(InputJackLibraryPropertyId.this);
                }
                return checker.parse(InputJackLibraryPropertyId.this).getMinorVersion();
            }

            @Override
            @Nonnull
            public String getDescription() {
                return "minor version of " + this.formatPropertyName(InputJackLibraryPropertyId.this);
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) {
                return "minor version of " + this.formatPropertyName(checker, InputJackLibraryPropertyId.this);
            }
        };
    }

    public BooleanExpression containsFileType(final @Nonnull FileType type) {
        return new BooleanExpression(){

            @Override
            public boolean eval(@Nonnull ConfigChecker checker) throws PropertyIdException, MissingPropertyException {
                if (!InputJackLibraryPropertyId.this.isRequired(checker)) {
                    throw new MissingPropertyException(InputJackLibraryPropertyId.this);
                }
                return checker.parse(InputJackLibraryPropertyId.this).containsFileType(type);
            }

            @Override
            @Nonnull
            public String getDescription() {
                return InputJackLibraryPropertyId.this.format(this.formatPropertyName(InputJackLibraryPropertyId.this), true, type);
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) throws PropertyIdException {
                try {
                    return InputJackLibraryPropertyId.this.format(this.formatPropertyName(InputJackLibraryPropertyId.this), this.eval(checker), type);
                }
                catch (MissingPropertyException e) {
                    return e.getMessage();
                }
            }
        };
    }

    @Nonnull
    private String format(@Nonnull String left, boolean set, @Nonnull FileType type) {
        StringBuilder sb = new StringBuilder();
        sb.append(left);
        if (!set) {
            sb.append(" does not contain any ");
        } else {
            sb.append(" contains ");
        }
        sb.append(type.toString());
        return sb.toString();
    }
}

