/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.library;

import com.android.jack.LibraryException;
import com.android.jack.library.InputJackLibrary;
import com.android.jack.library.JackLibraryFactory;
import com.android.sched.util.RunnableHooks;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.MessageDigestCodec;
import com.android.sched.util.codec.Parser;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.config.MessageDigestFactory;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.Directory;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.InputZipFile;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotFileOrDirectoryException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.file.ZipException;
import com.android.sched.vfs.BaseVFS;
import com.android.sched.vfs.CaseInsensitiveFS;
import com.android.sched.vfs.DirectFS;
import com.android.sched.vfs.ReadZipFS;
import com.android.sched.vfs.WrongVFSFormatException;
import java.io.File;
import java.security.Provider;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class InputJackLibraryCodec
implements StringCodec<InputJackLibrary> {
    @Nonnull
    private final MessageDigestCodec messageDigestCodec = new MessageDigestCodec();
    @CheckForNull
    private String infoString;

    @Override
    @Nonnull
    public InputJackLibrary parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return this.checkString(context, string);
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e);
        }
    }

    @Override
    @CheckForNull
    public InputJackLibrary checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        try {
            BaseVFS vfs;
            Directory workingDirectory = context.getWorkingDirectory();
            File dirOrZip = FileOrDirectory.getFileFromWorkingDirectory(workingDirectory, string);
            if (dirOrZip.isDirectory()) {
                DirectFS directFS = new DirectFS(new Directory(workingDirectory, string, context.getRunnableHooks(), FileOrDirectory.Existence.MUST_EXIST, 3, FileOrDirectory.ChangePermission.NOCHANGE), 3);
                directFS.setInfoString(this.infoString);
                try {
                    Provider.Service service = (Provider.Service)this.messageDigestCodec.checkString(context, "SHA");
                    vfs = new CaseInsensitiveFS(directFS, 1, 2, new MessageDigestFactory(service), false);
                }
                catch (WrongVFSFormatException e) {
                    vfs = directFS;
                }
            } else {
                RunnableHooks hooks = context.getRunnableHooks();
                ReadZipFS rzFS = new ReadZipFS(new InputZipFile(workingDirectory, string, hooks, FileOrDirectory.Existence.MUST_EXIST, FileOrDirectory.ChangePermission.NOCHANGE));
                rzFS.setInfoString(this.infoString);
                vfs = rzFS;
            }
            return JackLibraryFactory.getInputLibrary(vfs);
        }
        catch (LibraryException e) {
            throw new ParsingException(e.getMessage(), e);
        }
        catch (NotFileOrDirectoryException e) {
            throw new AssertionError((Object)e);
        }
        catch (FileAlreadyExistsException e) {
            throw new AssertionError((Object)e);
        }
        catch (CannotCreateFileException e) {
            throw new AssertionError((Object)e);
        }
        catch (CannotChangePermissionException e) {
            throw new AssertionError((Object)e);
        }
        catch (WrongPermissionException e) {
            throw new ParsingException(e.getMessage(), e);
        }
        catch (NoSuchFileException e) {
            throw new ParsingException(e.getMessage(), e);
        }
        catch (ZipException e) {
            throw new ParsingException(e.getMessage(), e);
        }
    }

    @Override
    @Nonnull
    public String getUsage() {
        return "a path to a jack library";
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return "jack";
    }

    @Override
    @Nonnull
    public List<Parser.ValueDescription> getValueDescriptions() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull InputJackLibrary data) {
        return data.getPath();
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull InputJackLibrary data) {
    }

    @Nonnull
    public InputJackLibraryCodec setInfoString(@CheckForNull String infoString) {
        this.infoString = infoString;
        return this;
    }
}

