/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.library;

import com.android.jack.Jack;
import com.android.jack.library.CommonJackLibrary;
import com.android.jack.library.FileType;
import com.android.jack.library.InputLibrary;
import com.android.jack.library.JackLibraryFactory;
import com.android.jack.library.LibraryFormatException;
import com.android.jack.library.LibraryLocation;
import com.android.jack.library.LibraryVersionException;
import com.android.jack.library.MissingLibraryPropertyException;
import com.android.sched.util.findbugs.SuppressFBWarnings;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.vfs.VFS;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public abstract class InputJackLibrary
extends CommonJackLibrary
implements InputLibrary {
    @Nonnull
    protected static final Logger logger = LoggerFactory.getLogger();
    @Nonnegative
    private final int minorVersion;
    @CheckForNull
    private Constructor<?> jayceReaderConstructor;
    @Nonnegative
    private int jayceMajorVersion;
    @Nonnegative
    private int jayceMinorVersion;
    @Nonnull
    private final LibraryLocation location;

    public InputJackLibrary(@Nonnull Properties libraryProperties, @Nonnull VFS vfs) throws LibraryFormatException {
        super(libraryProperties, vfs);
        this.location = new LibraryLocation(vfs.getLocation());
        this.locationList.add(this.location);
        try {
            this.minorVersion = Integer.parseInt(this.getProperty("lib.version.minor"));
        }
        catch (MissingLibraryPropertyException e) {
            logger.log(Level.SEVERE, e.getMessage());
            throw new LibraryFormatException(this.location);
        }
        catch (NumberFormatException e) {
            logger.log(Level.SEVERE, "Fails to parse the property lib.version.minor from " + this.location.getDescription(), e);
            throw new LibraryFormatException(this.location);
        }
    }

    @Override
    @Nonnull
    public final LibraryLocation getLocation() {
        return this.location;
    }

    @Nonnull
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"})
    public final Constructor<?> getJayceReaderConstructor() throws LibraryFormatException {
        this.ensureJayceLoaded();
        assert (this.jayceReaderConstructor != null);
        return this.jayceReaderConstructor;
    }

    @Nonnegative
    public final int getJayceMajorVersion() throws LibraryFormatException {
        this.ensureJayceLoaded();
        return this.jayceMajorVersion;
    }

    @Nonnegative
    public final int getJayceMinorVersion() throws LibraryFormatException {
        this.ensureJayceLoaded();
        return this.jayceMinorVersion;
    }

    private final synchronized void ensureJayceLoaded() throws LibraryFormatException {
        if (this.jayceReaderConstructor == null) {
            Class<?> jayceReaderClass;
            String jayceMajorVersionStr;
            try {
                jayceMajorVersionStr = this.getProperty(this.keyJayceMajorVersion);
                this.jayceMajorVersion = Integer.parseInt(jayceMajorVersionStr);
            }
            catch (MissingLibraryPropertyException e) {
                logger.log(Level.SEVERE, e.getMessage());
                throw new LibraryFormatException(this.location);
            }
            catch (NumberFormatException e) {
                logger.log(Level.SEVERE, "Failed to parse the property " + this.keyJayceMajorVersion + " from " + this.location.getDescription(), e);
                throw new LibraryFormatException(this.location);
            }
            try {
                this.jayceMinorVersion = Integer.parseInt(this.getProperty(this.keyJayceMinorVersion));
            }
            catch (MissingLibraryPropertyException e) {
                logger.log(Level.SEVERE, e.getMessage());
                throw new LibraryFormatException(this.location);
            }
            catch (NumberFormatException e) {
                logger.log(Level.SEVERE, "Failed to parse the property " + this.keyJayceMinorVersion + " from " + this.location.getDescription(), e);
                throw new LibraryFormatException(this.location);
            }
            String className = "com.android.jack.jayce.v" + JackLibraryFactory.getVersionString(this.jayceMajorVersion) + ".io.JayceInternalReaderImpl";
            try {
                jayceReaderClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                logger.log(Level.SEVERE, "Library " + this.location.getDescription() + " is invalid: Jayce version " + jayceMajorVersionStr + " not supported", e);
                throw new LibraryFormatException(this.location);
            }
            try {
                this.jayceReaderConstructor = jayceReaderClass.getConstructor(InputStream.class);
            }
            catch (SecurityException e) {
                throw new AssertionError((Object)"Security issue with Jayce stream");
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)("Jayce processing method not found for version " + jayceMajorVersionStr));
            }
        }
    }

    @Override
    @Nonnegative
    public final int getMinorVersion() {
        return this.minorVersion;
    }

    protected void check() throws LibraryVersionException, LibraryFormatException {
        try {
            this.getProperty("lib.emitter");
            this.getProperty("lib.emitter.version");
            this.getProperty("lib.version.major");
            this.getProperty("lib.version.minor");
        }
        catch (MissingLibraryPropertyException e) {
            logger.log(Level.SEVERE, e.getMessage());
            throw new LibraryFormatException(this.location);
        }
        int majorVersion = this.getMajorVersion();
        int minorVersion = this.getMinorVersion();
        int supportedMinorMin = this.getSupportedMinorMin();
        int supportedMinor = this.getSupportedMinor();
        if (minorVersion < supportedMinorMin) {
            throw new LibraryVersionException("The version of the library " + this.getLocation().getDescription() + " is not supported anymore. " + "Library version: " + majorVersion + "." + minorVersion + " - Current version: " + majorVersion + "." + supportedMinor + " - Minimum compatible version: " + majorVersion + "." + supportedMinorMin);
        }
        if (minorVersion > supportedMinor) {
            throw new LibraryVersionException("The version of the library " + this.getLocation().getDescription() + " is too recent. " + "Library version: " + majorVersion + "." + minorVersion + " - Current version: " + majorVersion + "." + supportedMinor);
        }
        if (minorVersion < supportedMinor) {
            Jack.getSession().getUserLogger().log(Level.WARNING, "The version of the library " + this.getLocation().getDescription() + " is older than the current version but is " + "supported. File version: {0}.{1} - Current version: {2}.{3}", new Object[]{majorVersion, minorVersion, majorVersion, supportedMinor});
        }
        for (FileType ft : this.fileTypes) {
            ft.check();
        }
    }

    @Nonnegative
    public abstract int getSupportedMinor();

    @Nonnegative
    public abstract int getSupportedMinorMin();

    public abstract boolean hasCompliantPrebuilts();
}

