/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.library;

import com.android.jack.Jack;
import com.android.jack.library.FileType;
import com.android.jack.library.InputJackLibrary;
import com.android.jack.library.InputLibrary;
import com.android.jack.library.JackLibrary;
import com.android.jack.library.MissingLibraryPropertyException;
import com.android.sched.util.location.Location;
import com.android.sched.vfs.InputVDir;
import com.android.sched.vfs.InputVElement;
import com.android.sched.vfs.InputVFile;
import com.android.sched.vfs.ReadWriteZipFS;
import com.android.sched.vfs.UnionVFS;
import com.android.sched.vfs.VFS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public abstract class CommonJackLibrary
implements JackLibrary {
    @Nonnull
    protected VFS vfs;
    @Nonnull
    protected final Properties libraryProperties;
    @Nonnull
    public final String keyJayceMajorVersion = this.buildPropertyName(FileType.JAYCE, ".version.major");
    @Nonnull
    public final String keyJayceMinorVersion = this.buildPropertyName(FileType.JAYCE, ".version.minor");
    @Nonnull
    protected List<Location> locationList = new ArrayList<Location>(1);
    @Nonnull
    public final Set<FileType> fileTypes = EnumSet.noneOf(FileType.class);

    public CommonJackLibrary(@Nonnull Properties libraryProperties, @Nonnull VFS vfs) {
        this.libraryProperties = libraryProperties;
        this.vfs = vfs;
    }

    @Override
    @Nonnull
    public boolean containsProperty(@Nonnull String key) {
        return this.libraryProperties.containsKey(key);
    }

    @Override
    @Nonnull
    public String getProperty(@Nonnull String key) throws MissingLibraryPropertyException {
        if (!this.libraryProperties.containsKey(key)) {
            throw new MissingLibraryPropertyException(key, this.getLocation());
        }
        return (String)this.libraryProperties.get(key);
    }

    public void putProperty(@Nonnull String key, @Nonnull String value) {
        this.libraryProperties.put(key, value);
    }

    @Nonnull
    public Collection<FileType> getFileTypes() {
        return Jack.getUnmodifiableCollections().getUnmodifiableCollection(this.fileTypes);
    }

    public boolean containsFileType(@Nonnull FileType fileType) {
        return this.fileTypes.contains((Object)fileType);
    }

    @Override
    @Nonnull
    public String buildPropertyName(@Nonnull FileType type, @CheckForNull String suffix) {
        return this.getPropertyPrefix(type) + (suffix == null ? "" : suffix);
    }

    @Nonnull
    protected abstract String getPropertyPrefix(@Nonnull FileType var1);

    protected void addFileType(@Nonnull FileType ft) {
        this.fileTypes.add(ft);
    }

    protected void fillFileTypes() {
        for (FileType ft : FileType.values()) {
            try {
                String propertyName = this.buildPropertyName(ft, null);
                if (!this.containsProperty(propertyName) || !Boolean.parseBoolean(this.getProperty(propertyName))) continue;
                this.fileTypes.add(ft);
            }
            catch (MissingLibraryPropertyException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    protected void fillFiles(@Nonnull InputVDir vDir, @Nonnull List<InputVFile> files) {
        for (InputVElement inputVElement : vDir.list()) {
            if (inputVElement.isVDir()) {
                this.fillFiles((InputVDir)inputVElement, files);
                continue;
            }
            files.add((InputVFile)inputVElement);
        }
    }

    @Nonnull
    public VFS getVfs() {
        return this.vfs;
    }

    @Override
    public boolean canBeMerged(@Nonnull List<? extends InputLibrary> inputLibraries) {
        if (this instanceof InputJackLibrary && !((InputJackLibrary)this).hasCompliantPrebuilts()) {
            return false;
        }
        int currentMajorVersion = this.getMajorVersion();
        for (InputLibrary inputLibrary : inputLibraries) {
            if (inputLibrary instanceof InputJackLibrary && inputLibrary.getMajorVersion() == currentMajorVersion && ((InputJackLibrary)inputLibrary).containsFileType(FileType.PREBUILT) && ((InputJackLibrary)inputLibrary).hasCompliantPrebuilts() && !((InputJackLibrary)inputLibrary).hasJayceDigest()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void mergeInputLibraries(@Nonnull List<? extends InputLibrary> inputLibraries) {
        assert (this.locationList.size() == 1);
        assert (this.canBeMerged(inputLibraries));
        ArrayList<VFS> inputLibVfsList = new ArrayList<VFS>(inputLibraries.size());
        for (InputLibrary inputLibrary : inputLibraries) {
            inputLibVfsList.add(((InputJackLibrary)inputLibrary).getVfs());
            this.locationList.add(inputLibrary.getLocation());
            this.fileTypes.addAll(((InputJackLibrary)inputLibrary).getFileTypes());
        }
        if (this.vfs instanceof ReadWriteZipFS) {
            ReadWriteZipFS zipVFS = (ReadWriteZipFS)this.vfs;
            VFS vFS = zipVFS.getWorkVFS();
            inputLibVfsList.add(0, vFS);
            zipVFS.setWorkVFS(new UnionVFS(inputLibVfsList));
        } else {
            inputLibVfsList.add(0, this.vfs);
            this.vfs = new UnionVFS(inputLibVfsList);
        }
    }

    public boolean containsLibraryLocation(@Nonnull Location location) {
        return this.locationList.contains(location);
    }

    public boolean hasJayceDigest() {
        return this.libraryProperties.getProperty("lib.jayce.digest", "").equals("true");
    }
}

