/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.nodes;

import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.jayce.v0004.NNode;
import com.android.jack.jayce.v0004.io.ExportSession;
import com.android.jack.jayce.v0004.io.ImportHelper;
import com.android.jack.jayce.v0004.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0004.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0004.io.Token;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NMethodId
extends NNode {
    @Nonnull
    public static final Token TOKEN = Token.METHODID_WITH_RETURN_TYPE;
    @CheckForNull
    String name;
    @CheckForNull
    String returnTypeSig;
    @Nonnull
    private List<String> paramTypeSigs = Collections.emptyList();
    @CheckForNull
    private MethodKind methodKind;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JMethodId mthIdToImplement = (JMethodId)node;
        this.name = mthIdToImplement.getMethodIdWide().getName();
        this.returnTypeSig = ImportHelper.getSignatureName(mthIdToImplement.getType());
        this.paramTypeSigs = ImportHelper.getSignatureNameList(mthIdToImplement.getMethodIdWide().getParamTypes());
        this.methodKind = mthIdToImplement.getMethodIdWide().getKind();
    }

    @Override
    @Nonnull
    public Object exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException, JMethodLookupException {
        assert (this.name != null);
        assert (this.returnTypeSig != null);
        assert (this.methodKind != null);
        JType returnType = exportSession.getLookup().getType(this.returnTypeSig);
        JMethodIdWide mthId = new JMethodIdWide(this.name, this.methodKind);
        for (String paramSig : this.paramTypeSigs) {
            mthId.addParam(exportSession.getLookup().getType(paramSig));
        }
        return new JMethodId(mthId, returnType);
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        assert (this.methodKind != null);
        out.writeId(this.name);
        out.writeMethodKindEnum(this.methodKind);
        out.writeId(this.returnTypeSig);
        out.writeIds(this.paramTypeSigs);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.name = in.readId();
        this.methodKind = in.readMethodKindEnum();
        this.returnTypeSig = in.readId();
        this.paramTypeSigs = in.readIds();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }
}

