/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.io;

import com.android.jack.jayce.v0004.io.ParseException;
import com.android.jack.util.StringUtils;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;

class JayceInputStream
implements DataInput {
    @Nonnull
    private final DataInputStream in;

    public JayceInputStream(InputStream in) {
        this.in = new DataInputStream(in);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.in.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.in.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.in.skipBytes(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.in.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.in.readChar();
    }

    @Override
    public int readInt() throws IOException {
        byte cur;
        int result = 0;
        int count = 0;
        int signBits = -1;
        do {
            cur = this.readByte();
            result |= (cur & 0x7F) << count * 7;
            signBits <<= 7;
        } while ((cur & 0x80) == 128 && ++count < 5);
        if ((cur & 0x80) == 128) {
            throw new ParseException("invalid LEB128 sequence");
        }
        if ((signBits >> 1 & result) != 0) {
            result |= signBits;
        }
        return result;
    }

    @Override
    public long readLong() throws IOException {
        long cur;
        long result = 0L;
        int count = 0;
        long signBits = -1L;
        do {
            cur = this.readByte();
            result |= (cur & 0x7FL) << count * 7;
            signBits <<= 7;
        } while ((cur & 0x80L) == 128L && ++count < 10);
        if ((cur & 0x80L) == 128L) {
            throw new ParseException("invalid LEB128 sequence");
        }
        if ((signBits >> 1 & result) != 0L) {
            result |= signBits;
        }
        return result;
    }

    @Override
    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        return this.in.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        int length = this.readInt();
        if (length == -1) {
            return null;
        }
        byte[] utf8String = new byte[length];
        this.in.readFully(utf8String);
        try {
            return StringUtils.utf8BytesToString(utf8String);
        }
        catch (java.text.ParseException e) {
            throw new ParseException(e);
        }
    }

    public byte[] readBuffer() throws IOException {
        int length = this.readInt();
        if (length == -1) {
            return null;
        }
        byte[] b = new byte[length];
        this.in.readFully(b);
        return b;
    }
}

