/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0003.nodes;

import com.android.jack.ir.ast.JArrayLiteral;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.v0003.io.ExportSession;
import com.android.jack.jayce.v0003.io.ImportHelper;
import com.android.jack.jayce.v0003.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0003.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0003.io.Token;
import com.android.jack.jayce.v0003.nodes.NLiteral;
import com.android.jack.jayce.v0003.nodes.NSourceInfo;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NArrayLiteral
extends NLiteral {
    @Nonnull
    public static final Token TOKEN = Token.ARRAY_LITERAL;
    @Nonnull
    public List<NLiteral> values = Collections.emptyList();
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JArrayLiteral jArrayLiteral = (JArrayLiteral)node;
        this.values = loader.load(NLiteral.class, jArrayLiteral.getValues());
        this.sourceInfo = loader.load(jArrayLiteral.getSourceInfo());
    }

    @Override
    @Nonnull
    public JArrayLiteral exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException, JMethodLookupException {
        assert (this.sourceInfo != null);
        ArrayList<JLiteral> jValues = new ArrayList<JLiteral>(this.values.size());
        for (NLiteral value : this.values) {
            jValues.add(value.exportAsJast(exportSession));
        }
        SourceInfo jSourceInfo = this.sourceInfo.exportAsJast(exportSession);
        JArrayLiteral jArrayLiteral = new JArrayLiteral(jSourceInfo, jValues);
        return jArrayLiteral;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeNodes(this.values);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.values = in.readNodes(NLiteral.class);
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }
}

