/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0003.io;

import com.android.jack.ir.ast.FieldKind;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JRetentionPolicy;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.jayce.DeclaredTypeNode;
import com.android.jack.jayce.JayceFormatException;
import com.android.jack.jayce.JayceInternalReader;
import com.android.jack.jayce.NodeLevel;
import com.android.jack.jayce.v0003.NNode;
import com.android.jack.jayce.v0003.io.InvalidTokenException;
import com.android.jack.jayce.v0003.io.ParseException;
import com.android.jack.jayce.v0003.io.Token;
import com.android.jack.jayce.v0003.io.Tokenizer;
import com.android.jack.jayce.v0003.nodes.HasCatchBlockIds;
import com.android.jack.jayce.v0003.nodes.HasSourceInfo;
import com.android.jack.jayce.v0003.nodes.NDeclaredType;
import com.android.jack.jayce.v0003.nodes.NMethod;
import com.android.jack.jayce.v0003.nodes.NMethodCall;
import com.android.jack.jayce.v0003.nodes.NSourceInfo;
import com.android.jack.jayce.v0003.util.DispatchKindIdHelper;
import com.android.jack.jayce.v0003.util.FieldRefKindIdHelper;
import com.android.jack.jayce.v0003.util.MethodKindIdHelper;
import com.android.jack.jayce.v0003.util.ReceiverKindIdHelper;
import com.android.jack.jayce.v0003.util.RetentionPolicyIdHelper;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.Percent;
import com.android.sched.util.log.stats.PercentImpl;
import com.android.sched.util.log.stats.StatisticId;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class JayceInternalReaderImpl
implements JayceInternalReader {
    @Nonnull
    public static final StatisticId<Percent> SKIPPED_TYPE_STRUCTURE = new StatisticId<Percent>("jack.jayce-to-nnode.structure.skipped", "Type structure reading skipped by the reader", PercentImpl.class, Percent.class);
    @Nonnull
    public static final StatisticId<Percent> SKIPPED_BODY = new StatisticId<Percent>("jack.jayce-to-nnode.body.skipped", "Method body reading skipped by the reader", PercentImpl.class, Percent.class);
    @Nonnull
    private final Tokenizer tokenizer;
    @Nonnull
    private NodeLevel nodeLevel = NodeLevel.FULL;
    @CheckForNull
    private NDeclaredType type;
    @CheckForNull
    private String currentFileName;
    @Nonnegative
    private int currentLine;
    @Nonnull
    private final List<String> currentCatchBlockList = new ArrayList<String>();
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();

    public JayceInternalReaderImpl(@Nonnull InputStream in) {
        this.tokenizer = new Tokenizer(in);
    }

    @Nonnull
    public NodeLevel getNodeLevel() {
        return this.nodeLevel;
    }

    @CheckForNull
    public String readId() throws IOException {
        return this.readString();
    }

    @CheckForNull
    public String readCurrentFileName() throws IOException {
        if (this.tokenizer.readOpenFileName()) {
            this.currentFileName = this.readString();
            this.tokenizer.readCloseFileName();
        }
        return this.currentFileName;
    }

    @Nonnegative
    public int readCurrentLine() throws IOException {
        if (this.tokenizer.readOpenLineInfo()) {
            this.currentLine = this.readInt();
            this.tokenizer.readCloseLineInfo();
        }
        return this.currentLine;
    }

    @Nonnull
    public JRetentionPolicy readRetentionPolicyEnum() throws IOException {
        return RetentionPolicyIdHelper.getValue(this.readByte());
    }

    @Nonnull
    public FieldKind readFieldRefKindEnum() throws IOException {
        return FieldRefKindIdHelper.getValue(this.readByte());
    }

    @Nonnull
    public MethodKind readMethodKindEnum() throws IOException {
        return MethodKindIdHelper.getValue(this.readByte());
    }

    @Nonnull
    public NMethodCall.ReceiverKind readReceiverKindEnum() throws IOException {
        return ReceiverKindIdHelper.getValue(this.readByte());
    }

    @Nonnull
    public JMethodCall.DispatchKind readDispatchKindEnum() throws IOException {
        return DispatchKindIdHelper.getValue(this.readByte());
    }

    @CheckForNull
    public String readString() throws IOException {
        return this.tokenizer.readString();
    }

    @CheckForNull
    public byte[] readBuffer() throws IOException {
        return this.tokenizer.readBuffer();
    }

    @Nonnull
    public List<String> readIds() throws IOException {
        this.tokenizer.readOpen();
        int length = this.readInt();
        ArrayList<String> ids = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            ids.add(this.readId());
        }
        this.tokenizer.readClose();
        return ids;
    }

    public void readCatchBlockIds() throws IOException {
        String id;
        int i;
        int length;
        if (this.tokenizer.readOpenCatchBlockIdAdd()) {
            length = this.tokenizer.readInt();
            for (i = 0; i < length; ++i) {
                id = this.readId();
                this.currentCatchBlockList.add(id);
                assert (this.currentCatchBlockList.indexOf(id) == this.currentCatchBlockList.lastIndexOf(id));
            }
            this.tokenizer.readCloseCatchBlockId();
        }
        if (this.tokenizer.readOpenCatchBlockIdRemove()) {
            length = this.tokenizer.readInt();
            for (i = 0; i < length; ++i) {
                id = this.readId();
                this.currentCatchBlockList.remove(id);
                assert (!this.currentCatchBlockList.contains(id));
            }
            this.tokenizer.readCloseCatchBlockId();
        }
    }

    @CheckForNull
    public <T extends NNode> T readNode(@Nonnull Class<T> nodeClass) throws IOException, JayceFormatException {
        NNode node;
        String fileName = this.readCurrentFileName();
        int startLine = this.readCurrentLine();
        this.readCatchBlockIds();
        Token token = this.tokenizer.next();
        if (token == Token.NULL) {
            return null;
        }
        this.tokenizer.readOpen();
        try {
            node = token.newNode();
        }
        catch (InvalidTokenException e) {
            throw new ParseException("Unexpected token " + token.toString() + " while expecting node.", e);
        }
        Percent statistic = null;
        if (token == Token.METHOD_BODY) {
            statistic = this.tracer.getStatistic(SKIPPED_BODY);
        } else if (node instanceof NDeclaredType) {
            this.tracer.getStatistic(SKIPPED_TYPE_STRUCTURE).add(this.nodeLevel == NodeLevel.TYPES);
        }
        if (!nodeClass.isAssignableFrom(node.getClass())) {
            throw new JayceFormatException("Unexpected node " + node.getClass().getSimpleName() + ", " + nodeClass.getSimpleName() + " was expected.");
        }
        if (this.nodeLevel != NodeLevel.TYPES && node instanceof HasSourceInfo) {
            NSourceInfo sourceInfo = new NSourceInfo();
            sourceInfo.fileName = fileName;
            sourceInfo.startLine = startLine;
            ((HasSourceInfo)((Object)node)).setSourceInfos(sourceInfo);
        }
        if (node instanceof HasCatchBlockIds) {
            ((HasCatchBlockIds)((Object)node)).setCatchBlockIds(new ArrayList<String>(this.currentCatchBlockList));
        }
        node.readContent(this);
        if (this.nodeLevel != NodeLevel.TYPES) {
            this.readSourceInfoEnd(node);
            assert (!(node instanceof NMethod) || this.currentCatchBlockList.isEmpty());
            this.tokenizer.readClose();
        }
        if (this.nodeLevel.keep(token.getNodeLevel())) {
            if (statistic != null) {
                statistic.addFalse();
            }
            return (T)node;
        }
        if (statistic != null) {
            statistic.addTrue();
        }
        return null;
    }

    private void readSourceInfoEnd(@Nonnull NNode node) throws IOException {
        if (node instanceof HasSourceInfo) {
            NSourceInfo sourceInfo = ((HasSourceInfo)((Object)node)).getSourceInfos();
            sourceInfo.endLine = this.readCurrentLine();
            if (sourceInfo.startLine == 0 && sourceInfo.endLine == 0 && !(node instanceof NDeclaredType)) {
                ((HasSourceInfo)((Object)node)).setSourceInfos(NSourceInfo.UNKNOWN);
            }
        }
    }

    @Nonnull
    public <T extends NNode> List<T> readNodes(@Nonnull Class<T> nodeClass) throws IOException, JayceFormatException {
        this.tokenizer.readOpen();
        int length = this.readInt();
        ArrayList<T> nodes = new ArrayList<T>(length);
        for (int i = 0; i < length; ++i) {
            T node = this.readNode(nodeClass);
            if (node == null) continue;
            nodes.add(node);
            ((NNode)node).setIndex(i);
        }
        this.tokenizer.readClose();
        return nodes;
    }

    public int readInt() throws IOException {
        return this.tokenizer.readInt();
    }

    public byte readByte() throws IOException {
        return this.tokenizer.readByte();
    }

    public boolean readBoolean() throws IOException {
        return this.tokenizer.readBoolean();
    }

    public long readLong() throws IOException {
        return this.tokenizer.readLong();
    }

    public short readShort() throws IOException {
        return this.tokenizer.readShort();
    }

    public char readChar() throws IOException {
        return this.tokenizer.readChar();
    }

    public float readFloat() throws IOException {
        return this.tokenizer.readFloat();
    }

    public double readDouble() throws IOException {
        return this.tokenizer.readDouble();
    }

    @Override
    @Nonnull
    public DeclaredTypeNode readType(@Nonnull NodeLevel nodeLevel) throws IOException, JayceFormatException {
        if (this.type == null) {
            this.nodeLevel = nodeLevel;
            this.type = this.readNode(NDeclaredType.class);
        }
        assert (this.type != null);
        return this.type;
    }

    @Override
    public int getCurrentMinor() {
        return 6;
    }

    @Override
    public int getMinorMin() {
        return 6;
    }
}

