/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0002.nodes;

import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.jayce.FieldNode;
import com.android.jack.jayce.JayceClassOrInterfaceLoader;
import com.android.jack.jayce.JayceFieldLoader;
import com.android.jack.jayce.NodeLevel;
import com.android.jack.jayce.v0002.NNode;
import com.android.jack.jayce.v0002.io.ExportSession;
import com.android.jack.jayce.v0002.io.ImportHelper;
import com.android.jack.jayce.v0002.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0002.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0002.io.Token;
import com.android.jack.jayce.v0002.nodes.HasSourceInfo;
import com.android.jack.jayce.v0002.nodes.NAnnotation;
import com.android.jack.jayce.v0002.nodes.NLiteral;
import com.android.jack.jayce.v0002.nodes.NMarker;
import com.android.jack.jayce.v0002.nodes.NSourceInfo;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NField
extends NNode
implements HasSourceInfo,
FieldNode {
    @Nonnull
    public static final Token TOKEN = Token.FIELD;
    protected static final int INDEX_UNKNOWN = -1;
    public int modifiers;
    @CheckForNull
    public String type;
    @CheckForNull
    public String name;
    @CheckForNull
    public NLiteral initialValue;
    @Nonnull
    public List<NAnnotation> annotations = Collections.emptyList();
    @Nonnull
    public List<NMarker> markers = Collections.emptyList();
    @CheckForNull
    public NSourceInfo sourceInfo;
    protected int fieldNodeIndex = -1;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JField jField = (JField)node;
        this.modifiers = jField.getModifier();
        this.type = ImportHelper.getSignatureName(jField.getType());
        this.name = jField.getName();
        this.initialValue = (NLiteral)loader.load(jField.getInitialValue());
        this.annotations = loader.load(NAnnotation.class, jField.getAnnotations());
        this.markers = loader.load(NMarker.class, jField.getAllMarkers());
        this.sourceInfo = loader.load(jField.getSourceInfo());
    }

    @Override
    @Nonnull
    public JField exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException, JMethodLookupException {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public JField exportAsJast(@Nonnull ExportSession exportSession, @Nonnull JayceClassOrInterfaceLoader enclosingLoader) throws JTypeLookupException, JMethodLookupException {
        assert (this.sourceInfo != null);
        assert (this.name != null);
        assert (this.type != null);
        JDefinedClassOrInterface enclosingType = exportSession.getCurrentType();
        assert (enclosingType != null);
        JField jField = new JField(this.sourceInfo.exportAsJast(exportSession), this.name, enclosingType, exportSession.getLookup().getType(this.type), this.modifiers, new JayceFieldLoader(this, this.fieldNodeIndex, enclosingLoader));
        assert (this.name != null);
        assert (this.type != null);
        exportSession.getFieldInitializerFieldResolver().addTarget(NField.getResolverFieldId(this.name, this.type), jField);
        if (this.initialValue != null) {
            jField.setInitialValue(this.initialValue.exportAsJast(exportSession));
        }
        for (NMarker marker : this.markers) {
            jField.addMarker(marker.exportAsJast(exportSession));
        }
        return jField;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeInt(this.modifiers);
        out.writeId(this.type);
        out.writeId(this.name);
        out.writeNode(this.initialValue);
        out.writeNodes(this.annotations);
        out.writeNodes(this.markers);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.modifiers = in.readInt();
        this.type = in.readId();
        this.name = in.readId();
        this.initialValue = in.readNode(NLiteral.class);
        this.annotations = in.readNodes(NAnnotation.class);
        this.markers = in.readNodes(NMarker.class);
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    @Override
    public void setIndex(int index) {
        this.fieldNodeIndex = index;
    }

    @Nonnull
    static String getResolverFieldId(@Nonnull String name, @Nonnull String type) {
        return name + "-" + type;
    }

    @Override
    public void loadAnnotations(@Nonnull JField loading, @Nonnull JayceFieldLoader loader) {
        if (!this.annotations.isEmpty()) {
            ExportSession exportSession = new ExportSession(loader.getSession(), NodeLevel.STRUCTURE);
            for (NAnnotation annotation : this.annotations) {
                JAnnotation annote = annotation.exportAsJast(exportSession);
                loading.addAnnotation(annote);
                annote.updateParents(loading);
            }
        }
    }
}

