/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0002.nodes;

import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.JayceClassOrInterfaceLoader;
import com.android.jack.jayce.NodeLevel;
import com.android.jack.jayce.v0002.io.ExportSession;
import com.android.jack.jayce.v0002.io.ImportHelper;
import com.android.jack.jayce.v0002.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0002.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0002.io.Token;
import com.android.jack.jayce.v0002.nodes.NAnnotation;
import com.android.jack.jayce.v0002.nodes.NDeclaredType;
import com.android.jack.jayce.v0002.nodes.NField;
import com.android.jack.jayce.v0002.nodes.NMarker;
import com.android.jack.jayce.v0002.nodes.NMethod;
import com.android.jack.jayce.v0002.nodes.NSourceInfo;
import com.android.jack.lookup.JMethodLookupException;
import com.android.jack.util.NamingTools;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NClassType
extends NDeclaredType {
    @Nonnull
    public static final Token TOKEN = Token.CLASS;
    public int modifiers;
    @CheckForNull
    public String signature;
    @CheckForNull
    public String superClass;
    @CheckForNull
    public String enclosingType;
    @CheckForNull
    public String enclosingMethodClass;
    @CheckForNull
    public String enclosingMethod;
    @Nonnull
    public List<String> inners = Collections.emptyList();
    @Nonnull
    public List<String> superInterfaces = Collections.emptyList();
    @Nonnull
    public List<NMarker> markers = Collections.emptyList();
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JDefinedClass jClassType = (JDefinedClass)node;
        this.modifiers = jClassType.getModifier();
        this.signature = ImportHelper.getSignatureName(jClassType);
        this.superClass = ImportHelper.getSignatureName(jClassType.getSuperClass());
        this.superInterfaces = ImportHelper.getSignatureNameList(jClassType.getImplements());
        this.enclosingType = ImportHelper.getSignatureName(jClassType.getEnclosingType());
        this.enclosingMethodClass = ImportHelper.getMethodClassSignature(jClassType.getEnclosingMethod());
        this.enclosingMethod = ImportHelper.getMethodSignature(jClassType.getEnclosingMethod());
        this.inners = ImportHelper.getSignatureNameList(jClassType.getMemberTypes());
        this.fields = loader.load(NField.class, jClassType.getFields());
        this.methods = loader.load(NMethod.class, jClassType.getMethods());
        this.annotations = loader.load(NAnnotation.class, jClassType.getAnnotations());
        this.markers = loader.load(NMarker.class, jClassType.getAllMarkers());
        this.sourceInfo = loader.load(jClassType.getSourceInfo());
    }

    @Override
    @Nonnull
    public JDefinedClass exportAsJast(@Nonnull ExportSession exportSession) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public JDefinedClass create(@Nonnull JPackage enclosingPackage, @Nonnull JayceClassOrInterfaceLoader loader) {
        assert (this.signature != null);
        String binaryName = NamingTools.getClassBinaryNameFromDescriptor(this.signature);
        String simpleName = NamingTools.getSimpleClassNameFromBinaryName(binaryName);
        this.modifiers &= 0xFFFBFFFF;
        JDefinedClass jClassType = new JDefinedClass(SourceInfo.UNKNOWN, simpleName, this.modifiers, enclosingPackage, loader);
        return jClassType;
    }

    @Override
    public void loadStructure(@Nonnull JDefinedClassOrInterface loading, @Nonnull JayceClassOrInterfaceLoader loader) {
        assert (this.sourceInfo != null);
        assert (this.signature != null);
        JDefinedClass jClassType = (JDefinedClass)loading;
        ExportSession exportSession = new ExportSession(loader.getSession(), NodeLevel.STRUCTURE);
        exportSession.setCurrentType(jClassType);
        loading.setSourceInfo(this.sourceInfo.exportAsJast(exportSession));
        if (this.superClass != null) {
            jClassType.setSuperClass(exportSession.getLookup().getClass(this.superClass));
        }
        for (String superInterface : this.superInterfaces) {
            jClassType.addImplements(exportSession.getLookup().getInterface(superInterface));
        }
        if (this.enclosingType != null) {
            jClassType.setEnclosingType((JClassOrInterface)exportSession.getLookup().getType(this.enclosingType));
        }
        if (this.enclosingMethodClass != null) {
            assert (this.enclosingMethod != null);
            JClass enclosingMethodJClass = exportSession.getLookup().getClass(this.enclosingMethodClass);
            if (enclosingMethodJClass instanceof JDefinedClass) {
                try {
                    jClassType.setEnclosingMethod(exportSession.getDeclaredMethod((JDefinedClass)enclosingMethodJClass, this.enclosingMethod));
                }
                catch (JMethodLookupException superInterface) {
                    // empty catch block
                }
            }
        }
        for (String memberType : this.inners) {
            jClassType.addMemberType((JClassOrInterface)exportSession.getLookup().getType(memberType));
        }
        for (NField field : this.fields) {
            JField jField = field.exportAsJast(exportSession, loader);
            jField.setEnclosingType(jClassType);
            jClassType.addField(jField);
        }
        for (NMethod method : this.methods) {
            JMethod jMethod = method.exportAsJast(exportSession, loader);
            jClassType.addMethod(jMethod);
        }
        for (NMarker marker : this.markers) {
            jClassType.addMarker(marker.exportAsJast(exportSession));
        }
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeInt(this.modifiers);
        out.writeId(this.signature);
        out.writeId(this.superClass);
        out.writeIds(this.superInterfaces);
        out.writeId(this.enclosingType);
        out.writeId(this.enclosingMethodClass);
        out.writeId(this.enclosingMethod);
        out.writeIds(this.inners);
        out.writeNodes(this.fields);
        out.writeNodes(this.methods);
        out.writeNodes(this.annotations);
        out.writeNodes(this.markers);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.level = in.getNodeLevel();
        this.modifiers = in.readInt();
        this.signature = in.readId();
        if (this.level != NodeLevel.TYPES) {
            this.superClass = in.readId();
            this.superInterfaces = in.readIds();
            this.enclosingType = in.readId();
            this.enclosingMethodClass = in.readId();
            this.enclosingMethod = in.readId();
            this.inners = in.readIds();
            this.fields = in.readNodes(NField.class);
            this.methods = in.readNodes(NMethod.class);
            assert (this.areIndicesValid());
            this.annotations = in.readNodes(NAnnotation.class);
            this.markers = in.readNodes(NMarker.class);
        }
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public String getSignature() {
        assert (this.signature != null);
        return this.signature;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }
}

