/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0002.nodes;

import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JRetentionPolicy;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.v0002.io.ExportSession;
import com.android.jack.jayce.v0002.io.ImportHelper;
import com.android.jack.jayce.v0002.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0002.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0002.io.Token;
import com.android.jack.jayce.v0002.nodes.NLiteral;
import com.android.jack.jayce.v0002.nodes.NNameValuePair;
import com.android.jack.jayce.v0002.nodes.NSourceInfo;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NAnnotation
extends NLiteral {
    @Nonnull
    public static final Token TOKEN = Token.ANNOTATION;
    @CheckForNull
    public JRetentionPolicy retentionPolicy;
    @CheckForNull
    public String annotationType;
    @Nonnull
    public List<NNameValuePair> elements = Collections.emptyList();
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JAnnotation jAnnotation = (JAnnotation)node;
        this.retentionPolicy = jAnnotation.getRetentionPolicy();
        this.annotationType = ImportHelper.getSignatureName(jAnnotation.getType());
        this.elements = loader.load(NNameValuePair.class, jAnnotation.getNameValuePairs());
        this.sourceInfo = loader.load(jAnnotation.getSourceInfo());
    }

    @Override
    @Nonnull
    public JAnnotation exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException, JMethodLookupException {
        assert (this.retentionPolicy != null);
        assert (this.sourceInfo != null);
        assert (this.annotationType != null);
        SourceInfo jSourceInfo = this.sourceInfo.exportAsJast(exportSession);
        JAnnotationType type = exportSession.getLookup().getAnnotationType(this.annotationType);
        JAnnotation jAnnotation = new JAnnotation(jSourceInfo, this.retentionPolicy, type);
        for (NNameValuePair valuePair : this.elements) {
            jAnnotation.put(valuePair.exportAsJast(exportSession, type));
        }
        return jAnnotation;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        assert (this.retentionPolicy != null);
        out.writeRetentionPolicyEnum(this.retentionPolicy);
        out.writeId(this.annotationType);
        out.writeNodes(this.elements);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.retentionPolicy = in.readRetentionPolicyEnum();
        this.annotationType = in.readId();
        this.elements = in.readNodes(NNameValuePair.class);
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }
}

