/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.linker;

import com.android.jack.jayce.linker.Linker;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class SymbolResolver<T> {
    @Nonnull
    private final Map<String, List<Linker<T>>> pendingSymbols = new HashMap<String, List<Linker<T>>>();
    @Nonnull
    private final Map<String, T> resolvedSymbols = new HashMap<String, T>();

    public void addLink(@Nonnull String symbol, @Nonnull Linker<T> link) {
        T resolved = this.resolvedSymbols.get(symbol);
        if (resolved != null) {
            link.link(resolved);
        } else {
            List<Linker<T>> linkList = this.pendingSymbols.get(symbol);
            if (linkList == null) {
                linkList = new LinkedList<Linker<T>>();
                this.pendingSymbols.put(symbol, linkList);
            }
            linkList.add(link);
        }
    }

    public void addTarget(@Nonnull String symbol, @Nonnull T target) {
        assert (!this.resolvedSymbols.containsKey(symbol));
        this.resolvedSymbols.put(symbol, target);
        List<Linker<T>> pendings = this.pendingSymbols.remove(symbol);
        if (pendings != null) {
            for (Linker<T> link : pendings) {
                link.link(target);
            }
        }
    }

    public void clear() {
        assert (this.pendingSymbols.isEmpty());
        this.resolvedSymbols.clear();
    }
}

