/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce;

import com.android.jack.LibraryException;
import com.android.jack.ir.ast.JAbstractMethodBody;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JSession;
import com.android.jack.jayce.DeclaredTypeNode;
import com.android.jack.jayce.JayceClassOrInterfaceLoader;
import com.android.jack.jayce.MethodNode;
import com.android.jack.jayce.NodeLevel;
import com.android.jack.library.HasInputLibrary;
import com.android.jack.library.InputLibrary;
import com.android.jack.library.LibraryFormatException;
import com.android.jack.library.LibraryIOException;
import com.android.jack.load.JackLoadingException;
import com.android.jack.load.MethodLoader;
import com.android.jack.lookup.JLookupException;
import com.android.sched.marker.Marker;
import com.android.sched.util.location.Location;
import com.android.sched.util.log.stats.Counter;
import com.android.sched.util.log.stats.CounterImpl;
import com.android.sched.util.log.stats.StatisticId;
import java.lang.ref.SoftReference;
import javax.annotation.Nonnull;

public class JayceMethodLoader
implements MethodLoader,
HasInputLibrary {
    @Nonnull
    private static final StatisticId<Counter> BODY_LOAD_COUNT = new StatisticId<Counter>("jack.nnode-to-jnode.body", "Body converted from a NNode in a JNode", CounterImpl.class, Counter.class);
    @Nonnull
    private final JayceClassOrInterfaceLoader enclosingClassLoader;
    @Nonnull
    private SoftReference<MethodNode> nnode;
    @Nonnull
    private final int methodNodeIndex;
    private boolean isBodyLoaded = false;
    private boolean isAnnotationsLoaded = false;

    public JayceMethodLoader(@Nonnull MethodNode nnode, int methodNodeIndex, @Nonnull JayceClassOrInterfaceLoader enclosingClassLoader) {
        this.enclosingClassLoader = enclosingClassLoader;
        this.nnode = new SoftReference<MethodNode>(nnode);
        this.methodNodeIndex = methodNodeIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureBody(@Nonnull JMethod loaded) {
        JayceMethodLoader jayceMethodLoader = this;
        synchronized (jayceMethodLoader) {
            JAbstractMethodBody body;
            MethodNode methodNode;
            if (this.isBodyLoaded) {
                return;
            }
            try {
                methodNode = this.getNNode(NodeLevel.FULL);
            }
            catch (LibraryException e) {
                throw new JackLoadingException(this.getLocation(loaded), e);
            }
            try {
                body = methodNode.loadBody(loaded, this);
            }
            catch (JLookupException e) {
                throw new JackLoadingException(this.getLocation(loaded), e);
            }
            if (body != null) {
                body.updateParents(loaded);
            }
            this.isBodyLoaded = true;
            this.enclosingClassLoader.tracer.getStatistic(BODY_LOAD_COUNT).incValue();
            if (this.isAnnotationsLoaded) {
                loaded.removeLoader();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureAnnotations(@Nonnull JMethod loaded) {
        JayceMethodLoader jayceMethodLoader = this;
        synchronized (jayceMethodLoader) {
            if (this.isAnnotationsLoaded) {
                return;
            }
            try {
                MethodNode node = this.getNNode(NodeLevel.STRUCTURE);
                node.loadAnnotations(loaded, this);
            }
            catch (LibraryException e) {
                throw new JackLoadingException(this.getLocation(loaded), e);
            }
            this.isAnnotationsLoaded = true;
            if (this.isBodyLoaded) {
                loaded.removeLoader();
            }
        }
    }

    @Nonnull
    MethodNode getNNode(@Nonnull NodeLevel minimumLevel) throws LibraryFormatException, LibraryIOException {
        MethodNode methodNode = this.nnode.get();
        if (methodNode == null || !methodNode.getLevel().keep(minimumLevel)) {
            DeclaredTypeNode declaredTypeNode = this.enclosingClassLoader.getNNode(minimumLevel);
            methodNode = declaredTypeNode.getMethodNode(this.methodNodeIndex);
            this.nnode = new SoftReference<MethodNode>(methodNode);
        }
        return methodNode;
    }

    @Override
    @Nonnull
    public Location getLocation(@Nonnull JMethod loaded) {
        return this.enclosingClassLoader.getLocation();
    }

    @Override
    public void ensureMarkers(@Nonnull JMethod loaded) {
    }

    @Override
    @Nonnull
    public InputLibrary getInputLibrary() {
        return this.enclosingClassLoader.getInputLibrary();
    }

    @Override
    public void ensureMarker(@Nonnull JMethod loaded, @Nonnull Class<? extends Marker> cls) {
        this.ensureMarkers(loaded);
    }

    @Override
    public void ensureAnnotation(@Nonnull JMethod loaded, @Nonnull JAnnotationType annotation) {
        this.ensureAnnotations(loaded);
    }

    @Nonnull
    public JSession getSession() {
        return this.enclosingClassLoader.getSession();
    }
}

