/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.sourceinfo;

import com.android.jack.ir.sourceinfo.FileSourceInfo;
import com.android.jack.ir.sourceinfo.SourceInfo;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class LineSourceInfo
extends SourceInfo {
    @Nonnull
    private final FileSourceInfo fileSourceInfo;
    @Nonnegative
    private final int startLine;
    @Nonnegative
    private final int endLine;

    LineSourceInfo(@Nonnull FileSourceInfo location, @Nonnegative int startLine, @Nonnegative int endLine) {
        assert (startLine != 0);
        this.fileSourceInfo = location;
        this.startLine = startLine;
        this.endLine = endLine;
    }

    public final boolean equals(@CheckForNull Object o) {
        if (!(o instanceof LineSourceInfo)) {
            return false;
        }
        LineSourceInfo other = (LineSourceInfo)o;
        return this.startLine == other.startLine && this.endLine == other.getEndLine() && this.fileSourceInfo.equals(other.fileSourceInfo);
    }

    @Override
    @Nonnull
    public FileSourceInfo getFileSourceInfo() {
        return this.fileSourceInfo;
    }

    @Override
    @Nonnegative
    public int getStartLine() {
        return this.startLine;
    }

    @Override
    @Nonnegative
    public int getEndLine() {
        return this.endLine;
    }

    public final int hashCode() {
        return 2 + 13 * this.fileSourceInfo.hashCode() + 17 * this.startLine + 19 * this.endLine;
    }

    @Nonnull
    public String toString() {
        return this.getFileName() + ":" + this.getStartLine() + '-' + this.getEndLine();
    }
}

