/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.formatter;

import com.android.jack.ir.ast.JArrayType;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.formatter.SourceFormatter;
import java.util.Iterator;
import javax.annotation.Nonnull;

public class IdentifierFormatter
extends SourceFormatter {
    @Nonnull
    private static final IdentifierFormatter formatter = new IdentifierFormatter();
    private static final char separator = '_';

    private IdentifierFormatter() {
    }

    @Nonnull
    public static IdentifierFormatter getFormatter() {
        return formatter;
    }

    @Override
    protected char getPackageSeparator() {
        return '_';
    }

    @Override
    @Nonnull
    public String getName(@Nonnull JType type) {
        if (type instanceof JArrayType) {
            return this.getName(((JArrayType)type).getElementType()) + '_';
        }
        return super.getName(type);
    }

    @Override
    @Nonnull
    public String getName(@Nonnull JMethod method) {
        StringBuilder sb = new StringBuilder(this.getName(method.getType()));
        sb.append('_');
        sb.append(method.getName().replace('<', '_').replace('>', '_'));
        sb.append('_');
        Iterator<JParameter> argumentIterator = method.getParams().iterator();
        while (argumentIterator.hasNext()) {
            JParameter argument = argumentIterator.next();
            sb.append(this.getName(argument.getType()));
            sb.append('_');
            sb.append(argument.getName());
            if (!argumentIterator.hasNext()) continue;
            sb.append('_');
        }
        sb.append('_');
        return sb.toString();
    }
}

