/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JUnaryOperator;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import javax.annotation.Nonnull;

@Description(value="Java prefix or postfix operation expression")
public abstract class JUnaryOperation
extends JExpression {
    private JExpression arg;

    public JUnaryOperation(@Nonnull SourceInfo info, @Nonnull JExpression arg) {
        super(info);
        this.arg = arg;
    }

    public JExpression getArg() {
        return this.arg;
    }

    @Nonnull
    public abstract JUnaryOperator getOp();

    @Override
    @Nonnull
    public JType getType() {
        return JPrimitiveType.getUnaryPromotion(this.arg.getType());
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        visitor.accept(this.arg);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        this.arg.traverse(schedule);
    }

    @Override
    protected void replaceImpl(@Nonnull JNode existingNode, @Nonnull JNode newNode) throws UnsupportedOperationException {
        assert (newNode != null);
        if (this.arg == existingNode) {
            this.arg = (JExpression)newNode;
        } else {
            super.replaceImpl(existingNode, newNode);
        }
    }
}

