/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.Jack;
import com.android.jack.ir.JNodeInternalError;
import com.android.jack.ir.ast.JAbstractMethodBody;
import com.android.jack.ir.ast.JCatchBlock;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Description;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

@Description(value="Java program statement")
public abstract class JStatement
extends JNode {
    @Nonnull
    private final List<JCatchBlock> catchBlocks = new ArrayList<JCatchBlock>();

    public JStatement(@Nonnull SourceInfo info) {
        super(info);
    }

    @Override
    protected boolean isResultOfExpressionUsed(JExpression expr) {
        return true;
    }

    public void appendCatchBlock(@Nonnull JCatchBlock catchBlock) {
        assert (!this.catchBlocks.contains(catchBlock));
        this.catchBlocks.add(catchBlock);
    }

    public void setCatchBlocks(@Nonnull List<JCatchBlock> catchBlocks) {
        assert (this.catchBlocks.isEmpty());
        this.catchBlocks.addAll(catchBlocks);
    }

    public void removeCatchBlocks(@Nonnull List<JCatchBlock> catchBlocksToRemove) {
        this.catchBlocks.removeAll(catchBlocksToRemove);
    }

    @Nonnull
    public List<JCatchBlock> getJCatchBlocks() {
        return Jack.getUnmodifiableCollections().getUnmodifiableList(this.catchBlocks);
    }

    @Override
    public void checkValidity() {
        if (!(this.parent instanceof JStatement) && !(this.parent instanceof JAbstractMethodBody)) {
            throw new JNodeInternalError(this, "Invalid parent");
        }
    }

    public boolean isUnconditionalBranch() {
        return false;
    }
}

