/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.Jack;
import com.android.jack.analysis.dependency.file.FileDependencies;
import com.android.jack.analysis.dependency.library.LibraryDependencies;
import com.android.jack.analysis.dependency.type.TypeDependencies;
import com.android.jack.google.common.collect.Iterators;
import com.android.jack.incremental.InputFilter;
import com.android.jack.ir.JNodeInternalError;
import com.android.jack.ir.ast.JArrayType;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.Resource;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.ir.sourceinfo.SourceInfoFactory;
import com.android.jack.library.FileType;
import com.android.jack.library.InputJackLibrary;
import com.android.jack.library.InputLibrary;
import com.android.jack.library.OutputJackLibrary;
import com.android.jack.load.PackageLoader;
import com.android.jack.lookup.JNodeLookup;
import com.android.jack.lookup.JPhantomLookup;
import com.android.jack.meta.Meta;
import com.android.jack.reporting.Reporter;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import com.android.sched.util.RunnableHooks;
import com.android.sched.util.config.ReflectFactory;
import com.android.sched.util.config.ThreadConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Representing a compilation")
public class JSession
extends JNode {
    @Nonnull
    private final Set<JDefinedClassOrInterface> typesToEmit = new HashSet<JDefinedClassOrInterface>();
    @Nonnull
    private JPackage topLevelPackage;
    @Nonnull
    private JNodeLookup lookup;
    @Nonnull
    private JPhantomLookup phantomLookup;
    @Nonnull
    private JArrayType[] primitiveArrays = new JArrayType[JPrimitiveType.JPrimitiveTypeEnum.values().length];
    @Nonnull
    private final SourceInfoFactory sourceInfoFactory = new SourceInfoFactory();
    @Nonnull
    private final List<Resource> resources = new ArrayList<Resource>();
    @Nonnull
    private final List<Meta> metas = new ArrayList<Meta>();
    @Nonnull
    private final Logger userLogger = Logger.getLogger("Jack");
    @CheckForNull
    private Reporter reporter;
    @Nonnull
    private final List<FileType> generatedBinaryKinds = new ArrayList<FileType>(2);
    @CheckForNull
    private OutputJackLibrary jackOutputLibrary;
    @Nonnull
    private final List<InputLibrary> importedLibraries = new ArrayList<InputLibrary>(0);
    @Nonnull
    private final List<InputLibrary> librariesOnClasspath = new ArrayList<InputLibrary>(0);
    @Nonnull
    private final LibraryDependencies libDependencies = new LibraryDependencies();
    @CheckForNull
    private TypeDependencies typeDependencies;
    @CheckForNull
    private FileDependencies fileDependencies;
    @CheckForNull
    private InputFilter inputFilter;
    @CheckForNull
    private RunnableHooks hooks;
    private boolean mustAbortEventually = false;

    public JSession() {
        super(SourceInfo.UNKNOWN);
        this.topLevelPackage = new JPackage("", null);
        this.topLevelPackage.updateParents(this);
        this.lookup = new JNodeLookup(this.topLevelPackage);
        this.phantomLookup = new JPhantomLookup(this.lookup);
    }

    public void reset() {
        this.typesToEmit.clear();
        this.topLevelPackage = new JPackage("", null);
        this.topLevelPackage.updateParents(this);
        this.lookup = new JNodeLookup(this.topLevelPackage);
        this.phantomLookup = new JPhantomLookup(this.lookup);
        this.primitiveArrays = new JArrayType[JPrimitiveType.JPrimitiveTypeEnum.values().length];
        ReflectFactory importFactory = (ReflectFactory)((Object)ThreadConfig.getConfig().get(Jack.IMPORT_POLICY));
        for (InputLibrary library : this.getImportedLibraries()) {
            if (!(library instanceof InputJackLibrary)) continue;
            this.topLevelPackage.addLoader((PackageLoader)importFactory.create(library, this));
        }
        ReflectFactory classpathFactory = (ReflectFactory)((Object)ThreadConfig.getConfig().get(Jack.CLASSPATH_POLICY));
        for (InputLibrary library : this.getLibraryOnClasspath()) {
            if (!(library instanceof InputJackLibrary)) continue;
            this.topLevelPackage.addLoader((PackageLoader)classpathFactory.create(library, this));
        }
    }

    @CheckForNull
    public InputFilter getInputFilter() {
        return this.inputFilter;
    }

    @Nonnull
    public void setInputFilter(@Nonnull InputFilter inputFilter) {
        this.inputFilter = inputFilter;
    }

    @Nonnull
    public JNodeLookup getLookup() {
        return this.lookup;
    }

    @Nonnull
    public JPhantomLookup getPhantomLookup() {
        return this.phantomLookup;
    }

    @Deprecated
    @Nonnull
    public Logger getUserLogger() {
        return this.userLogger;
    }

    @Nonnull
    public Reporter getReporter() {
        assert (this.reporter != null);
        return this.reporter;
    }

    @Nonnull
    public SourceInfoFactory getSourceInfoFactory() {
        return this.sourceInfoFactory;
    }

    public void abortEventually() {
        this.mustAbortEventually = true;
    }

    public boolean mustAbortEventually() {
        return this.mustAbortEventually;
    }

    public void addTypeToEmit(@Nonnull JDefinedClassOrInterface type) {
        this.typesToEmit.add(type);
        type.setToEmit(true);
    }

    public void removeTypeToEmit(@Nonnull JDefinedClassOrInterface type) {
        boolean removed = this.typesToEmit.remove(type);
        assert (removed);
        type.setToEmit(false);
    }

    @Nonnull
    public Collection<JDefinedClassOrInterface> getTypesToEmit() {
        return this.typesToEmit;
    }

    @Nonnull
    public JPackage getTopLevelPackage() {
        return this.topLevelPackage;
    }

    public void addResource(@Nonnull Resource resource) {
        this.resources.add(resource);
    }

    @Nonnull
    public List<Resource> getResources() {
        return this.resources;
    }

    public void addMeta(@Nonnull Meta meta) {
        this.metas.add(meta);
    }

    @Nonnull
    public List<Meta> getMetas() {
        return this.metas;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            visitor.accept(this.topLevelPackage);
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        this.topLevelPackage.traverse(schedule);
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Nonnull
    synchronized JArrayType getArrayOf(JPrimitiveType.JPrimitiveTypeEnum primitive) {
        assert (!primitive.equals((Object)JPrimitiveType.JPrimitiveTypeEnum.VOID));
        if (this.primitiveArrays[primitive.ordinal()] == null) {
            this.primitiveArrays[primitive.ordinal()] = new JArrayType(primitive.getType());
        }
        return this.primitiveArrays[primitive.ordinal()];
    }

    @Override
    public void checkValidity() {
        if (this.parent != null) {
            throw new JNodeInternalError(this, "Invalid parent");
        }
    }

    @Nonnull
    public OutputJackLibrary getJackOutputLibrary() {
        assert (this.jackOutputLibrary != null);
        return this.jackOutputLibrary;
    }

    public void setJackOutputLibrary(@Nonnull OutputJackLibrary jackOutputLibrary) {
        this.jackOutputLibrary = jackOutputLibrary;
    }

    @Nonnull
    public List<FileType> getGeneratedFileTypes() {
        return this.generatedBinaryKinds;
    }

    public void addGeneratedFileType(@Nonnull FileType fileType) {
        this.generatedBinaryKinds.add(fileType);
    }

    public void addImportedLibrary(@Nonnull InputLibrary source) {
        this.importedLibraries.add(source);
    }

    @Nonnull
    public List<InputLibrary> getImportedLibraries() {
        return Jack.getUnmodifiableCollections().getUnmodifiableList(this.importedLibraries);
    }

    public void addLibraryOnClasspath(@Nonnull InputLibrary source) {
        this.librariesOnClasspath.add(source);
    }

    @Nonnull
    public List<InputLibrary> getLibraryOnClasspath() {
        return Jack.getUnmodifiableCollections().getUnmodifiableList(this.librariesOnClasspath);
    }

    @Nonnull
    public Iterator<InputLibrary> getPathSources() {
        return Iterators.concat(this.importedLibraries.iterator(), this.librariesOnClasspath.iterator());
    }

    @Nonnull
    public TypeDependencies getTypeDependencies() {
        assert (this.typeDependencies != null);
        return this.typeDependencies;
    }

    @Nonnull
    public FileDependencies getFileDependencies() {
        assert (this.fileDependencies != null);
        return this.fileDependencies;
    }

    @Nonnull
    public LibraryDependencies getLibraryDependencies() {
        return this.libDependencies;
    }

    public void setTypeDependencies(@Nonnull TypeDependencies typeDependencies) {
        this.typeDependencies = typeDependencies;
    }

    public void setFileDependencies(@Nonnull FileDependencies fileDependencies) {
        this.fileDependencies = fileDependencies;
    }

    public void setHooks(@Nonnull RunnableHooks hooks) {
        this.hooks = hooks;
    }

    @Nonnull
    public RunnableHooks getHooks() {
        assert (this.hooks != null);
        return this.hooks;
    }

    public void setReporter(@Nonnull Reporter reporter) {
        this.reporter = reporter;
    }
}

