/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.google.common.collect.Lists;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Represents multiple ordered expressions")
public class JMultiExpression
extends JExpression {
    @Nonnull
    public List<JExpression> exprs;

    public JMultiExpression(@Nonnull SourceInfo info, @Nonnull List<JExpression> exprs) {
        super(info);
        this.exprs = exprs;
    }

    public JMultiExpression(@Nonnull SourceInfo info, JExpression ... exprs) {
        super(info);
        this.exprs = Lists.newArrayList(exprs);
    }

    @Override
    @Nonnull
    public JType getType() {
        int c = this.exprs.size();
        if (c == 0) {
            return JPrimitiveType.JPrimitiveTypeEnum.VOID.getType();
        }
        return this.exprs.get(c - 1).getType();
    }

    @Nonnull
    public List<JExpression> getExprs() {
        return this.exprs;
    }

    @Override
    protected boolean isResultOfExpressionUsed(@Nonnull JExpression expr) {
        assert (this.exprs.contains(expr));
        JNode parent = this.getParent();
        assert (parent != null);
        return this.exprs.lastIndexOf(expr) == this.exprs.size() - 1 && parent.isResultOfExpressionUsed(this);
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            visitor.accept(this.exprs);
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        for (JExpression expr : this.exprs) {
            expr.traverse(schedule);
        }
    }

    @Override
    protected void transform(@Nonnull JNode existingNode, @CheckForNull JNode newNode, @Nonnull JNode.Transformation transformation) {
        if (!JMultiExpression.transform(this.exprs, existingNode, (JExpression)newNode, transformation)) {
            super.transform(existingNode, newNode, transformation);
        }
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }
}

