/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.Jack;
import com.android.jack.ir.HierarchyFilter;
import com.android.jack.ir.ast.HasType;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JReferenceType;
import com.android.jack.ir.ast.JType;
import com.android.sched.item.Component;
import com.android.sched.marker.LocalMarkerManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class JMethodId
extends LocalMarkerManager
implements Component,
HasType {
    @Nonnull
    private final JMethodIdWide methodId;
    @Nonnull
    private final JType returnType;
    @Nonnull
    private final List<JMethod> methods = new ArrayList<JMethod>();

    public JMethodId(@Nonnull JMethodIdWide methodId, @Nonnull JType returnType) {
        this.methodId = methodId;
        this.returnType = returnType;
        methodId.addMethodId(this);
    }

    @Override
    @Nonnull
    public JType getType() {
        return this.returnType;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(@CheckForNull Object obj) {
        return obj == this;
    }

    @Nonnull
    public Collection<JMethod> getMethods(@Nonnull JReferenceType reference, @Nonnull HierarchyFilter filter) {
        Collection<JMethod> methods = this.getMethods();
        ArrayList<JMethod> subset = new ArrayList<JMethod>(methods.size());
        switch (filter) {
            case SUPER_TYPES: {
                for (JMethod jMethod : methods) {
                    if (!reference.canBeSafelyUpcast(jMethod.getEnclosingType())) continue;
                    subset.add(jMethod);
                }
                break;
            }
            case SUB_TYPES: {
                for (JMethod jMethod : methods) {
                    if (!jMethod.getEnclosingType().canBeSafelyUpcast(reference)) continue;
                    subset.add(jMethod);
                }
                break;
            }
            case SUB_AND_SUPER_TYPES: {
                for (JMethod jMethod : methods) {
                    if (!reference.canBeSafelyUpcast(jMethod.getEnclosingType()) && !jMethod.getEnclosingType().canBeSafelyUpcast(reference)) continue;
                    subset.add(jMethod);
                }
                break;
            }
            case THIS_TYPE: {
                for (JMethod jMethod : methods) {
                    if (!jMethod.getEnclosingType().isSameType(reference)) continue;
                    subset.add(jMethod);
                }
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return subset;
    }

    public void addMethod(@Nonnull JMethod method) {
        this.methods.add(method);
        assert (this.canBeResultId());
    }

    @Nonnull
    public JMethodIdWide getMethodIdWide() {
        return this.methodId;
    }

    @Nonnull
    public Collection<JMethod> getMethods() {
        return Jack.getUnmodifiableCollections().getUnmodifiableCollection(this.methods);
    }

    private boolean canBeResultId() {
        for (JMethod method : this.methods) {
            if (method.getMethodId().equals(this)) continue;
            return false;
        }
        return true;
    }
}

