/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.JAbstractMethodCall;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JPolymorphicMethodCall;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Java method call expression")
public class JMethodCall
extends JAbstractMethodCall {
    @Nonnull
    private final DispatchKind dispatchKind;

    public JMethodCall(@Nonnull JMethodCall other, @CheckForNull JExpression instance) {
        super(other.getSourceInfo(), instance, other.getReceiverType(), other.getMethodId(), other.getType());
        this.dispatchKind = other.getDispatchKind();
        assert (other.getReceiverType() == null || !JPolymorphicMethodCall.isCallToPolymorphicMethod(other.getReceiverType(), other.getMethodId(), other.getType()));
    }

    public JMethodCall(@Nonnull SourceInfo info, @CheckForNull JExpression instance, @Nonnull JClassOrInterface receiverType, @Nonnull JMethodIdWide methodId, @Nonnull JType returnType, boolean isVirtualDispatch) {
        super(info, instance, receiverType, methodId, returnType);
        assert (methodId != null);
        assert (receiverType == null || !JPolymorphicMethodCall.isCallToPolymorphicMethod(receiverType, methodId, returnType));
        assert (!isVirtualDispatch || methodId.getKind() == MethodKind.INSTANCE_VIRTUAL);
        this.dispatchKind = isVirtualDispatch ? DispatchKind.VIRTUAL : DispatchKind.DIRECT;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            this.visitChildren(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        this.visitChildren(schedule);
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Nonnull
    public DispatchKind getDispatchKind() {
        return this.dispatchKind;
    }

    public static enum DispatchKind {
        VIRTUAL,
        DIRECT;

    }
}

