/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.Jack;
import com.android.jack.ir.JNodeInternalError;
import com.android.jack.ir.ast.Annotable;
import com.android.jack.ir.ast.CanBeAbstract;
import com.android.jack.ir.ast.CanBeNative;
import com.android.jack.ir.ast.CanBeSetFinal;
import com.android.jack.ir.ast.CanBeStatic;
import com.android.jack.ir.ast.HasEnclosingType;
import com.android.jack.ir.ast.HasModifier;
import com.android.jack.ir.ast.HasName;
import com.android.jack.ir.ast.HasType;
import com.android.jack.ir.ast.JAbstractMethodBody;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JConstructor;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JLambda;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JModifier;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JThis;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.formatter.UserFriendlyFormatter;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.load.MethodLoader;
import com.android.jack.load.NopMethodLoader;
import com.android.jack.util.AnnotationUtils;
import com.android.jack.util.TriStateBoolean;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="A Java method implementation")
public class JMethod
extends JNode
implements HasEnclosingType,
HasName,
HasType,
CanBeAbstract,
CanBeSetFinal,
CanBeNative,
CanBeStatic,
Annotable,
HasModifier {
    @CheckForNull
    private JAbstractMethodBody body = null;
    @Nonnull
    private final JDefinedClassOrInterface enclosingType;
    private int modifier;
    @Nonnull
    private final ArrayList<JParameter> params = new ArrayList();
    @Nonnull
    private final List<JAnnotation> annotations = new ArrayList<JAnnotation>();
    @Nonnull
    private JMethodId methodId;
    @CheckForNull
    private JThis jThis;
    @Nonnull
    private MethodLoader loader;
    @Nonnull
    TriStateBoolean hasPolymorphicSignature = TriStateBoolean.UNDEFINED;

    public JMethod(@Nonnull SourceInfo info, @Nonnull JMethodId methodId, @Nonnull JDefinedClassOrInterface enclosingType, int modifier) {
        this(info, methodId, enclosingType, modifier, NopMethodLoader.INSTANCE);
    }

    public JMethod(@Nonnull SourceInfo info, @Nonnull JMethodId methodId, @Nonnull JDefinedClassOrInterface enclosingType, int modifier, @Nonnull MethodLoader loader) {
        super(info);
        assert (JModifier.isMethodModifier(modifier)) : "Wrong method modifier.";
        assert (JModifier.isValidMethodModifier(modifier));
        this.enclosingType = enclosingType;
        this.modifier = modifier;
        this.methodId = methodId;
        this.loader = loader;
        this.jThis = JMethod.needThis(modifier) ? new JThis(this) : null;
        this.setMethodId(methodId);
    }

    @Nonnull
    public MethodLoader getLoader() {
        return this.loader;
    }

    @Override
    public int getModifier() {
        return this.modifier;
    }

    @Override
    public void setModifier(int modifier) {
        assert (JModifier.isMethodModifier(modifier));
        assert (JModifier.isValidMethodModifier(modifier));
        this.modifier = modifier;
        this.hasPolymorphicSignature = TriStateBoolean.UNDEFINED;
    }

    public void addParam(JParameter parameter) {
        this.params.add(parameter);
        this.hasPolymorphicSignature = TriStateBoolean.UNDEFINED;
    }

    public void prependParam(JParameter parameter) {
        this.params.add(0, parameter);
        this.hasPolymorphicSignature = TriStateBoolean.UNDEFINED;
    }

    public boolean canBeVirtual() {
        return !this.isStatic() && !this.isPrivate();
    }

    @CheckForNull
    public JAbstractMethodBody getBody() {
        this.loader.ensureBody(this);
        return this.body;
    }

    @Override
    @Nonnull
    public JDefinedClassOrInterface getEnclosingType() {
        return this.enclosingType;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.methodId.getMethodIdWide().getName();
    }

    @Nonnull
    public List<JParameter> getParams() {
        return this.params;
    }

    @Override
    @Nonnull
    public JType getType() {
        return this.methodId.getType();
    }

    @Override
    public boolean isAbstract() {
        return JModifier.isAbstract(this.modifier);
    }

    @Override
    public boolean isFinal() {
        return JModifier.isFinal(this.modifier);
    }

    @Override
    public boolean isNative() {
        return JModifier.isNative(this.modifier);
    }

    public boolean isPublic() {
        return JModifier.isPublic(this.modifier);
    }

    public boolean isPrivate() {
        return JModifier.isPrivate(this.modifier);
    }

    public boolean isProtected() {
        return JModifier.isProtected(this.modifier);
    }

    @Override
    public boolean isStatic() {
        return JModifier.isStatic(this.modifier);
    }

    public boolean isSynchronized() {
        return JModifier.isSynchronized(this.modifier);
    }

    public boolean isSynthetic() {
        return JModifier.isSynthetic(this.modifier);
    }

    public boolean isStrictfp() {
        return JModifier.isStrictfp(this.modifier);
    }

    public boolean isVarags() {
        return JModifier.isVarargs(this.modifier);
    }

    public boolean isBridge() {
        return JModifier.isBridge(this.modifier);
    }

    public void setAbstract() {
        this.modifier |= 0x400;
    }

    public void setBody(JAbstractMethodBody body) {
        this.body = body;
        if (body != null) {
            body.setMethod(this);
        }
    }

    @Override
    public void setFinal() {
        this.modifier |= 0x10;
    }

    public void setSynthetic() {
        this.modifier |= 0x1000;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            this.visitChildren(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        this.visitChildren(schedule);
    }

    @Override
    public void addAnnotation(@Nonnull JAnnotation annotation) {
        this.annotations.add(annotation);
    }

    @Nonnull
    public List<JAnnotation> getAnnotations(@Nonnull JAnnotationType annotationType) {
        this.loader.ensureAnnotation(this, annotationType);
        return Jack.getUnmodifiableCollections().getUnmodifiableList(AnnotationUtils.getAnnotation(this.annotations, annotationType));
    }

    @Override
    @Nonnull
    public Collection<JAnnotation> getAnnotations() {
        this.loader.ensureAnnotations(this);
        return Jack.getUnmodifiableCollections().getUnmodifiableCollection(this.annotations);
    }

    @Override
    @Nonnull
    public Set<JAnnotationType> getAnnotationTypes() {
        this.loader.ensureAnnotations(this);
        return Jack.getUnmodifiableCollections().getUnmodifiableSet(AnnotationUtils.getAnnotationTypes(this.annotations));
    }

    @Override
    @CheckForNull
    public <T extends Marker> T getMarker(@Nonnull Class<T> cls) {
        this.loader.ensureMarker(this, cls);
        return super.getMarker(cls);
    }

    @Override
    @Nonnull
    public Collection<Marker> getAllMarkers() {
        this.loader.ensureMarkers(this);
        return super.getAllMarkers();
    }

    @Override
    public <T extends Marker> boolean containsMarker(@Nonnull Class<T> cls) {
        this.loader.ensureMarker(this, cls);
        return super.containsMarker(cls);
    }

    @Override
    public <T extends Marker> T removeMarker(@Nonnull Class<T> cls) {
        this.loader.ensureMarker(this, cls);
        return super.removeMarker(cls);
    }

    @Override
    @Nonnull
    public <T extends Marker> T getMarkerOrDefault(@Nonnull T defaultMarker) {
        this.loader.ensureMarker(this, defaultMarker.getClass());
        return super.getMarkerOrDefault(defaultMarker);
    }

    @Override
    @CheckForNull
    public <T extends Marker> T addMarkerIfAbsent(@Nonnull T marker) {
        this.loader.ensureMarker(this, marker.getClass());
        return super.addMarkerIfAbsent(marker);
    }

    @Override
    public void addAllMarkers(@Nonnull Collection<Marker> collection) {
        this.loader.ensureMarkers(this);
        super.addAllMarkers(collection);
    }

    protected void visitChildren(@Nonnull JVisitor visitor) {
        if (visitor.needLoading()) {
            this.loader.ensureBody(this);
            this.loader.ensureAnnotations(this);
        }
        if (this.jThis != null) {
            visitor.accept(this.jThis);
        }
        visitor.accept(this.params);
        if (this.body != null) {
            visitor.accept(this.body);
        }
        visitor.accept(this.annotations);
    }

    protected void visitChildren(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        if (this.jThis != null) {
            this.jThis.traverse(schedule);
        }
        for (JParameter param : this.params) {
            param.traverse(schedule);
        }
        if (this.body != null) {
            this.body.traverse(schedule);
        }
        for (JAnnotation annotation : this.annotations) {
            annotation.traverse(schedule);
        }
    }

    @Override
    protected void transform(@Nonnull JNode existingNode, @CheckForNull JNode newNode, @Nonnull JNode.Transformation transformation) throws UnsupportedOperationException {
        if (!JMethod.transform(this.params, existingNode, (JParameter)newNode, transformation)) {
            if (!JMethod.transform(this.annotations, existingNode, (JAnnotation)newNode, transformation)) {
                super.transform(existingNode, newNode, transformation);
            }
        } else {
            this.hasPolymorphicSignature = TriStateBoolean.UNDEFINED;
        }
    }

    @Override
    protected void replaceImpl(@Nonnull JNode existingNode, @Nonnull JNode newNode) throws UnsupportedOperationException {
        assert (newNode != null);
        if (this.body == existingNode) {
            this.body = (JAbstractMethodBody)newNode;
        } else {
            super.replaceImpl(existingNode, newNode);
        }
    }

    @Override
    protected void removeImpl(@Nonnull JNode existingNode) throws UnsupportedOperationException {
        if (this.body == existingNode) {
            this.body = null;
        } else {
            super.removeImpl(existingNode);
        }
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Nonnull
    public JMethodIdWide getMethodIdWide() {
        return this.methodId.getMethodIdWide();
    }

    @Nonnull
    public JMethodId getMethodId() {
        return this.methodId;
    }

    public void setMethodId(@Nonnull JMethodId methodId) {
        assert (this.getExpectedMethodKind() == methodId.getMethodIdWide().getKind());
        assert (methodId.getType().equals(this.methodId.getType()));
        this.methodId = methodId;
        methodId.addMethod(this);
    }

    private MethodKind getExpectedMethodKind() {
        MethodKind expectedKind = this.isStatic() ? MethodKind.STATIC : (this.isPrivate() || this instanceof JConstructor ? MethodKind.INSTANCE_NON_VIRTUAL : MethodKind.INSTANCE_VIRTUAL);
        return expectedKind;
    }

    @CheckForNull
    public JThis getThis() {
        return this.jThis;
    }

    public void setThis(@CheckForNull JThis jThis) {
        this.jThis = jThis;
    }

    public static boolean isClinit(@Nonnull JMethod method) {
        return method.getName().equals("<clinit>");
    }

    public void removeLoader() {
        this.loader = NopMethodLoader.INSTANCE;
    }

    @Override
    public void checkValidity() {
        if (!(this.parent instanceof JDefinedClassOrInterface) && !(this.parent instanceof JLambda)) {
            throw new JNodeInternalError(this, "Invalid parent");
        }
        if (this.params.size() != this.methodId.getMethodIdWide().getParamTypes().size()) {
            throw new JNodeInternalError(this, "Parameter size does not match type size of MethodID.");
        }
    }

    public static boolean needThis(int modifier) {
        return !JModifier.isStatic(modifier) && !JModifier.isAbstract(modifier) && !JModifier.isNative(modifier);
    }

    public boolean hasPolymorphicSignature() {
        if (this.hasPolymorphicSignature.isUndefined()) {
            UserFriendlyFormatter formatter = UserFriendlyFormatter.getFormatter();
            this.hasPolymorphicSignature = formatter.getName(this.getEnclosingType()).equals("java.lang.invoke.MethodHandle") && this.isVarags() && this.params.size() == 1 && formatter.getName(this.params.get(0).getType()).equals("java.lang.Object[]") && formatter.getName(this.getType()).equals("java.lang.Object") && this.isNative() ? TriStateBoolean.TRUE : TriStateBoolean.FALSE;
        }
        return this.hasPolymorphicSignature.isTrue();
    }
}

