/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import javax.annotation.Nonnull;

@Description(value="Java if statement")
public class JIfStatement
extends JStatement {
    private JStatement elseStmt;
    private JExpression ifExpr;
    private JStatement thenStmt;

    public JIfStatement(SourceInfo info, JExpression ifExpr, JStatement thenStmt, JStatement elseStmt) {
        super(info);
        this.ifExpr = ifExpr;
        this.thenStmt = thenStmt;
        this.elseStmt = elseStmt;
    }

    public JStatement getElseStmt() {
        return this.elseStmt;
    }

    public JExpression getIfExpr() {
        return this.ifExpr;
    }

    public JStatement getThenStmt() {
        return this.thenStmt;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            visitor.accept(this.ifExpr);
            if (this.thenStmt != null) {
                visitor.accept(this.thenStmt);
            }
            if (this.elseStmt != null) {
                visitor.accept(this.elseStmt);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        this.ifExpr.traverse(schedule);
        if (this.thenStmt != null) {
            this.thenStmt.traverse(schedule);
        }
        if (this.elseStmt != null) {
            this.elseStmt.traverse(schedule);
        }
    }

    @Override
    protected void replaceImpl(@Nonnull JNode existingNode, @Nonnull JNode newNode) {
        assert (newNode != null);
        if (this.elseStmt == existingNode) {
            this.elseStmt = (JStatement)newNode;
        } else if (this.thenStmt == existingNode) {
            this.thenStmt = (JStatement)newNode;
        } else if (this.ifExpr == existingNode) {
            this.ifExpr = (JExpression)newNode;
        } else {
            super.replaceImpl(existingNode, newNode);
            return;
        }
    }

    @Override
    protected void removeImpl(@Nonnull JNode existingNode) throws UnsupportedOperationException {
        if (this.thenStmt == existingNode) {
            this.thenStmt = null;
        } else if (this.elseStmt == existingNode) {
            this.elseStmt = null;
        } else {
            super.removeImpl(existingNode);
        }
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }
}

