/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JFieldRef;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import javax.annotation.Nonnull;

@Description(value="Statement setting the initial value of fields")
public class JFieldInitializer
extends JStatement {
    @Nonnull
    private JExpression initializer;
    @Nonnull
    private JFieldRef fieldRef;

    public JFieldInitializer(@Nonnull SourceInfo info, @Nonnull JFieldRef fieldRef, @Nonnull JExpression intializer) {
        super(info);
        this.fieldRef = fieldRef;
        this.initializer = intializer;
    }

    @Nonnull
    public JExpression getInitializer() {
        return this.initializer;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            visitor.accept(this.getFieldRef());
            visitor.accept(this.initializer);
        }
        visitor.endVisit(this);
    }

    public JFieldRef getFieldRef() {
        return this.fieldRef;
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        this.getFieldRef().traverse(schedule);
        this.initializer.traverse(schedule);
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Override
    protected void replaceImpl(@Nonnull JNode existingNode, @Nonnull JNode newNode) {
        if (existingNode == this.initializer) {
            this.initializer = (JExpression)newNode;
        } else if (this.fieldRef == existingNode) {
            this.fieldRef = (JFieldRef)newNode;
        } else {
            super.replaceImpl(existingNode, newNode);
        }
    }
}

